/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.messaging;

import io.smallrye.common.annotation.Experimental;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.eclipse.microprofile.reactive.messaging.Metadata;

public interface Message<T> {
    public static final Logger LOGGER = Logger.getLogger(Message.class.getName());

    public static <T> Message<T> of(T payload) {
        return () -> payload;
    }

    public static <T> Message<T> of(final T payload, Metadata metadata) {
        if (metadata == null) {
            metadata = Metadata.empty();
        }
        final Metadata actual = metadata;
        return new Message<T>(){

            @Override
            public T getPayload() {
                return payload;
            }

            @Override
            public Metadata getMetadata() {
                return actual;
            }
        };
    }

    public static <T> Message<T> of(final T payload, Iterable<Object> metadata) {
        final Metadata validated = Metadata.from(metadata);
        return new Message<T>(){

            @Override
            public T getPayload() {
                return payload;
            }

            @Override
            public Metadata getMetadata() {
                return validated;
            }
        };
    }

    public static <T> Message<T> of(final T payload, final Supplier<CompletionStage<Void>> ack) {
        return new Message<T>(){

            @Override
            public T getPayload() {
                return payload;
            }

            @Override
            public Metadata getMetadata() {
                return Metadata.empty();
            }

            @Override
            public Supplier<CompletionStage<Void>> getAck() {
                return ack;
            }
        };
    }

    public static <T> Message<T> of(final T payload, Metadata metadata, final Supplier<CompletionStage<Void>> ack) {
        if (metadata == null) {
            metadata = Metadata.empty();
        }
        final Metadata actual = metadata;
        return new Message<T>(){

            @Override
            public T getPayload() {
                return payload;
            }

            @Override
            public Metadata getMetadata() {
                return actual;
            }

            @Override
            public Supplier<CompletionStage<Void>> getAck() {
                return ack;
            }
        };
    }

    public static <T> Message<T> of(final T payload, Iterable<Object> metadata, final Supplier<CompletionStage<Void>> ack) {
        final Metadata validated = Metadata.from(metadata);
        return new Message<T>(){

            @Override
            public T getPayload() {
                return payload;
            }

            @Override
            public Metadata getMetadata() {
                return validated;
            }

            @Override
            public Supplier<CompletionStage<Void>> getAck() {
                return ack;
            }
        };
    }

    @Experimental(value="nack support is a SmallRye-only feature")
    public static <T> Message<T> of(final T payload, final Supplier<CompletionStage<Void>> ack, final Function<Throwable, CompletionStage<Void>> nack) {
        return new Message<T>(){

            @Override
            public T getPayload() {
                return payload;
            }

            @Override
            public Metadata getMetadata() {
                return Metadata.empty();
            }

            @Override
            public Supplier<CompletionStage<Void>> getAck() {
                return ack;
            }

            @Override
            public Function<Throwable, CompletionStage<Void>> getNack() {
                return nack;
            }
        };
    }

    @Experimental(value="nack support is a SmallRye-only feature")
    public static <T> Message<T> of(final T payload, Iterable<Object> metadata, final Supplier<CompletionStage<Void>> ack, final Function<Throwable, CompletionStage<Void>> nack) {
        final Metadata validated = Metadata.from(metadata);
        return new Message<T>(){

            @Override
            public T getPayload() {
                return payload;
            }

            @Override
            public Metadata getMetadata() {
                return validated;
            }

            @Override
            public Supplier<CompletionStage<Void>> getAck() {
                return ack;
            }

            @Override
            public Function<Throwable, CompletionStage<Void>> getNack() {
                return nack;
            }
        };
    }

    @Experimental(value="nack support is a SmallRye-only feature")
    public static <T> Message<T> of(final T payload, Metadata metadata, final Supplier<CompletionStage<Void>> ack, final Function<Throwable, CompletionStage<Void>> nack) {
        if (metadata == null) {
            metadata = Metadata.empty();
        }
        final Metadata actual = metadata;
        return new Message<T>(){

            @Override
            public T getPayload() {
                return payload;
            }

            @Override
            public Metadata getMetadata() {
                return actual;
            }

            @Override
            public Supplier<CompletionStage<Void>> getAck() {
                return ack;
            }

            @Override
            public Function<Throwable, CompletionStage<Void>> getNack() {
                return nack;
            }
        };
    }

    default public <P> Message<P> withPayload(P payload) {
        return Message.of(payload, Metadata.from(this.getMetadata()), this.getAck(), this.getNack());
    }

    default public Message<T> withMetadata(Iterable<Object> metadata) {
        return Message.of(this.getPayload(), Metadata.from(metadata), this.getAck(), this.getNack());
    }

    default public Message<T> withMetadata(Metadata metadata) {
        return Message.of(this.getPayload(), Metadata.from(metadata), this.getAck(), this.getNack());
    }

    default public Message<T> withAck(Supplier<CompletionStage<Void>> supplier) {
        return Message.of(this.getPayload(), this.getMetadata(), supplier, this.getNack());
    }

    @Experimental(value="nack support is a SmallRye-only feature")
    default public Message<T> withNack(Function<Throwable, CompletionStage<Void>> nack) {
        return Message.of(this.getPayload(), this.getMetadata(), this.getAck(), nack);
    }

    public T getPayload();

    default public Metadata getMetadata() {
        return Metadata.empty();
    }

    default public <M> Optional<M> getMetadata(Class<? extends M> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("`clazz` must not be `null`");
        }
        for (Object item : this.getMetadata()) {
            if (!clazz.isInstance(item)) continue;
            return Optional.of(item);
        }
        return Optional.empty();
    }

    default public Supplier<CompletionStage<Void>> getAck() {
        return () -> CompletableFuture.completedFuture(null);
    }

    @Experimental(value="nack support is a SmallRye-only feature")
    default public Function<Throwable, CompletionStage<Void>> getNack() {
        return reason -> CompletableFuture.completedFuture(null);
    }

    default public CompletionStage<Void> ack() {
        Supplier<CompletionStage<Void>> ack = this.getAck();
        if (ack == null) {
            return CompletableFuture.completedFuture(null);
        }
        return ack.get();
    }

    @Experimental(value="nack support is a SmallRye-only feature")
    default public CompletionStage<Void> nack(Throwable reason) {
        return this.nack(reason, null);
    }

    @Experimental(value="nack support is a SmallRye-only feature; metadata propagation is a SmallRye-specific feature")
    default public CompletionStage<Void> nack(Throwable reason, Metadata metadata) {
        if (reason == null) {
            throw new IllegalArgumentException("The reason must not be `null`");
        }
        Function<Throwable, CompletionStage<Void>> nack = this.getNack();
        if (nack == null) {
            LOGGER.warning(String.format("A message has been nacked, but no nack function has been provided. The reason was: %s", reason.getMessage()));
            LOGGER.finer(String.format("The full failure is: %s", reason));
            return CompletableFuture.completedFuture(null);
        }
        return nack.apply(reason);
    }

    default public <C> C unwrap(Class<C> unwrapType) {
        if (unwrapType == null) {
            throw new IllegalArgumentException("The target class must not be `null`");
        }
        try {
            return unwrapType.cast(this);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Cannot unwrap an instance of " + this.getClass().getName() + " to " + unwrapType.getName(), e);
        }
    }

    default public Message<T> addMetadata(Object metadata) {
        return Message.of(this.getPayload(), this.getMetadata().with(metadata), this.getAck(), this.getNack());
    }
}

