/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.api;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;

public class IncomingKafkaRecordBatchMetadata<K, T> {
    private final ConsumerRecords<K, T> records;
    private final String channel;
    private final int index;
    private final Map<TopicPartition, OffsetAndMetadata> offsets;

    public IncomingKafkaRecordBatchMetadata(ConsumerRecords<K, T> records, String channel, int index, Map<TopicPartition, OffsetAndMetadata> offsets) {
        this.records = records;
        this.channel = channel;
        this.index = index;
        this.offsets = Collections.unmodifiableMap(offsets);
    }

    public IncomingKafkaRecordBatchMetadata(ConsumerRecords<K, T> records, String channel, Map<TopicPartition, OffsetAndMetadata> offsets) {
        this(records, channel, -1, offsets);
    }

    public String getChannel() {
        return this.channel;
    }

    public ConsumerRecords<K, T> getRecords() {
        return this.records;
    }

    public int count() {
        return this.records.count();
    }

    public Set<TopicPartition> partitions() {
        return this.records.partitions();
    }

    public Map<TopicPartition, OffsetAndMetadata> getOffsets() {
        return this.offsets;
    }

    public int getConsumerIndex() {
        return this.index;
    }
}

