/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.MediatorConfiguration;
import io.smallrye.reactive.messaging.Shape;
import io.smallrye.reactive.messaging.providers.AbstractMediator;
import io.smallrye.reactive.messaging.providers.helpers.MultiUtils;
import io.smallrye.reactive.messaging.providers.i18n.ProviderExceptions;
import io.smallrye.reactive.messaging.providers.i18n.ProviderMessages;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.reactivestreams.Publisher;

public class PublisherMediator
extends AbstractMediator {
    private Multi<? extends Message<?>> publisher;

    public PublisherMediator(MediatorConfiguration configuration) {
        super(configuration);
        if (configuration.shape() != Shape.PUBLISHER) {
            throw ProviderExceptions.ex.illegalArgumentForPublisherShape(configuration.shape());
        }
    }

    @Override
    public Multi<? extends Message<?>> getStream() {
        return Objects.requireNonNull(this.publisher);
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    protected <T> Uni<T> invokeBlocking(Object ... args) {
        return super.invokeBlocking(null, args).onItem().invoke(item -> {
            if (item == null) {
                throw ProviderExceptions.ex.nullPointerOnInvokeBlocking(this.configuration.methodAsString());
            }
        });
    }

    @Override
    public void initialize(Object bean) {
        super.initialize(bean);
        switch (this.configuration.production()) {
            case STREAM_OF_MESSAGE: {
                if (this.configuration.usesBuilderTypes()) {
                    this.produceAPublisherBuilderOfMessages();
                    break;
                }
                this.produceAPublisherOfMessages();
                break;
            }
            case STREAM_OF_PAYLOAD: {
                if (this.configuration.usesBuilderTypes()) {
                    this.produceAPublisherBuilderOfPayloads();
                    break;
                }
                this.produceAPublisherOfPayloads();
                break;
            }
            case INDIVIDUAL_PAYLOAD: {
                this.produceIndividualPayloads();
                break;
            }
            case INDIVIDUAL_MESSAGE: {
                this.produceIndividualMessages();
                break;
            }
            case COMPLETION_STAGE_OF_MESSAGE: {
                this.produceIndividualCompletionStageOfMessages();
                break;
            }
            case COMPLETION_STAGE_OF_PAYLOAD: {
                this.produceIndividualCompletionStageOfPayloads();
                break;
            }
            case UNI_OF_MESSAGE: {
                this.produceIndividualUniOfMessages();
                break;
            }
            case UNI_OF_PAYLOAD: {
                this.produceIndividualUniOfPayloads();
                break;
            }
            default: {
                throw ProviderExceptions.ex.illegalArgumentForUnexpectedProduction(this.configuration.production());
            }
        }
        assert (this.publisher != null);
    }

    private void produceAPublisherBuilderOfMessages() {
        PublisherBuilder builder = (PublisherBuilder)this.invoke(new Object[0]);
        this.publisher = this.decorate(Multi.createFrom().publisher(builder.buildRs()));
    }

    private <P> void produceAPublisherBuilderOfPayloads() {
        PublisherBuilder builder = (PublisherBuilder)this.invoke(new Object[0]);
        this.publisher = this.decorate(Multi.createFrom().publisher(builder.map(Message::of).buildRs()));
    }

    private void produceAPublisherOfMessages() {
        this.publisher = Multi.createFrom().publisher((Publisher)this.invoke(new Object[0]));
    }

    private <P> void produceAPublisherOfPayloads() {
        Publisher pub = (Publisher)this.invoke(new Object[0]);
        this.publisher = this.decorate(Multi.createFrom().publisher(pub).map(Message::of));
    }

    private void produceIndividualMessages() {
        this.publisher = this.configuration.isBlocking() ? (this.configuration.isBlockingExecutionOrdered() ? this.decorate(MultiUtils.createFromGenerator(() -> this.invokeBlocking(new Object[0])).onItem().transformToUniAndConcatenate(u -> u).onItem().transform(o -> (Message)o)) : this.decorate(MultiUtils.createFromGenerator(() -> this.invokeBlocking(new Object[0])).onItem().transformToUniAndMerge(u -> u).onItem().transform(o -> (Message)o))) : this.decorate(MultiUtils.createFromGenerator(() -> {
            Message message = (Message)this.invoke(new Object[0]);
            Objects.requireNonNull(message, ProviderMessages.msg.methodReturnedNull(this.configuration.methodAsString()));
            return message;
        }));
    }

    private void produceIndividualPayloads() {
        this.publisher = this.configuration.isBlocking() ? (this.configuration.isBlockingExecutionOrdered() ? this.decorate(MultiUtils.createFromGenerator(() -> this.invokeBlocking(new Object[0])).onItem().transformToUniAndConcatenate(u -> u).onItem().transform(Message::of)) : this.decorate(MultiUtils.createFromGenerator(() -> this.invokeBlocking(new Object[0])).onItem().transformToUniAndMerge(u -> u).onItem().transform(Message::of))) : this.decorate(MultiUtils.createFromGenerator(() -> this.invoke(new Object[0])).onItem().transform(Message::of));
    }

    private void produceIndividualCompletionStageOfMessages() {
        this.publisher = this.decorate(MultiUtils.createFromGenerator(() -> (CompletionStage)this.invoke(new Object[0])).onItem().transformToUniAndConcatenate(cs -> Uni.createFrom().completionStage(cs)));
    }

    private <P> void produceIndividualCompletionStageOfPayloads() {
        this.publisher = this.decorate(MultiUtils.createFromGenerator(() -> (CompletionStage)this.invoke(new Object[0])).onItem().transformToUniAndConcatenate(cs -> Uni.createFrom().completionStage(cs).map(Message::of)));
    }

    private void produceIndividualUniOfMessages() {
        this.publisher = this.decorate(MultiUtils.createFromGenerator(() -> (Uni)this.invoke(new Object[0])).onItem().transformToUniAndConcatenate(Function.identity()));
    }

    private void produceIndividualUniOfPayloads() {
        this.publisher = this.decorate(MultiUtils.createFromGenerator(() -> (Uni)this.invoke(new Object[0])).onItem().transformToUniAndConcatenate(u -> u.map(Message::of)));
    }
}

