package io.smallrye.faulttolerance.config;

import io.smallrye.common.annotation.NonBlocking;
import io.smallrye.faulttolerance.autoconfig.Config;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.lang.annotation.Annotation;

/**
 * Automatically generated from the {@link NonBlockingConfig} config interface, do not modify.
 */
public final class NonBlockingConfigImpl implements NonBlockingConfig {
    private final Class<?> beanClass;

    private final MethodDescriptor method;

    /**
     * Backing annotation instance. Used when runtime configuration doesn't override it.
     */
    private final NonBlocking instance;

    /**
     * {@code true} if annotation was placed on a method; {@code false} if annotation was placed on a class.
     */
    private final boolean onMethod;

    private NonBlockingConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.nonBlocking;
        this.onMethod = method.annotationsPresentDirectly.contains(NonBlocking.class);
    }

    public static NonBlockingConfigImpl create(FaultToleranceMethod method) {
        if (method.nonBlocking == null) {
            return null;
        }
        if (!Config.isEnabled(NonBlocking.class, method.method)) {
            return null;
        }
        return new NonBlockingConfigImpl(method);
    }

    @Override
    public Class<?> beanClass() {
        return beanClass;
    }

    @Override
    public MethodDescriptor method() {
        return method;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return NonBlocking.class;
    }

    @Override
    public boolean isOnMethod() {
        return onMethod;
    }

    private String getConfigKeyForMethod(String key) {
        return method.declaringClass.getName() + "/" + method.name + "/" + "NonBlocking" + "/" + key;
    }

    private String getConfigKeyForClass(String key) {
        return method.declaringClass.getName() + "/" + "NonBlocking" + "/" + key;
    }
}
