/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.externaldocs;

import com.fasterxml.jackson.databind.JsonNode;
import io.smallrye.openapi.api.models.ExternalDocumentationImpl;
import io.smallrye.openapi.runtime.io.IoLogging;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.extension.ExtensionReader;
import io.smallrye.openapi.runtime.util.JandexUtil;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;

public class ExternalDocsReader {
    private ExternalDocsReader() {
    }

    public static ExternalDocumentation readExternalDocs(AnnotationValue annotationValue) {
        if (annotationValue == null) {
            return null;
        }
        return ExternalDocsReader.readExternalDocs(annotationValue.asNested());
    }

    public static ExternalDocumentation readExternalDocs(AnnotationInstance annotationInstance) {
        if (annotationInstance == null) {
            return null;
        }
        IoLogging.log.annotation("@ExternalDocumentation");
        ExternalDocumentationImpl externalDoc = new ExternalDocumentationImpl();
        externalDoc.setDescription(JandexUtil.stringValue(annotationInstance, "description"));
        externalDoc.setUrl(JandexUtil.stringValue(annotationInstance, "url"));
        return externalDoc;
    }

    public static ExternalDocumentation readExternalDocs(JsonNode node) {
        if (node == null) {
            return null;
        }
        ExternalDocumentationImpl externalDoc = new ExternalDocumentationImpl();
        externalDoc.setDescription(JsonUtil.stringProperty(node, "description"));
        externalDoc.setUrl(JsonUtil.stringProperty(node, "url"));
        ExtensionReader.readExtensions(node, externalDoc);
        return externalDoc;
    }
}

