/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.converter;

import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.converter.ModelConverter;
import io.swagger.converter.ModelConverterContextImpl;
import io.swagger.jackson.ModelResolver;
import io.swagger.oas.models.media.Schema;
import io.swagger.util.Json;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelConverters {
    private static final ModelConverters SINGLETON = new ModelConverters();
    static Logger LOGGER = LoggerFactory.getLogger(ModelConverters.class);
    private final List<ModelConverter> converters;
    private final Set<String> skippedPackages = new HashSet<String>();
    private final Set<String> skippedClasses = new HashSet<String>();

    public ModelConverters() {
        this.converters = new CopyOnWriteArrayList<ModelConverter>();
        this.converters.add(new ModelResolver(Json.mapper()));
    }

    public static ModelConverters getInstance() {
        return SINGLETON;
    }

    public void addConverter(ModelConverter converter) {
        this.converters.add(0, converter);
    }

    public void removeConverter(ModelConverter converter) {
        this.converters.remove(converter);
    }

    public void addPackageToSkip(String pkg) {
        this.skippedPackages.add(pkg);
    }

    public void addClassToSkip(String cls) {
        LOGGER.warn("skipping class " + cls);
        this.skippedClasses.add(cls);
    }

    public Schema resolveProperty(Type type) {
        if (this.shouldProcess(type)) {
            ModelConverterContextImpl context = new ModelConverterContextImpl(this.converters);
            return context.resolve(type, null);
        }
        return null;
    }

    public Map<String, Schema> read(Type type) {
        HashMap<String, Schema> modelMap = new HashMap<String, Schema>();
        if (this.shouldProcess(type)) {
            ModelConverterContextImpl context = new ModelConverterContextImpl(this.converters);
            Schema resolve = context.resolve(type);
            for (Map.Entry<String, Schema> entry : context.getDefinedModels().entrySet()) {
                if (!entry.getValue().equals((Object)resolve)) continue;
                modelMap.put(entry.getKey(), entry.getValue());
            }
        }
        return modelMap;
    }

    public Map<String, Schema> readAll(Type type) {
        if (this.shouldProcess(type)) {
            ModelConverterContextImpl context = new ModelConverterContextImpl(this.converters);
            LOGGER.debug("ModelConverters readAll from " + type);
            context.resolve(type);
            return context.getDefinedModels();
        }
        return new HashMap<String, Schema>();
    }

    private boolean shouldProcess(Type type) {
        Class cls = TypeFactory.defaultInstance().constructType(type).getRawClass();
        if (cls.isPrimitive()) {
            return false;
        }
        String className = cls.getName();
        for (String packageName : this.skippedPackages) {
            if (!className.startsWith(packageName)) continue;
            return false;
        }
        for (String classToSkip : this.skippedClasses) {
            if (!className.equals(classToSkip)) continue;
            return false;
        }
        return true;
    }

    static {
        ModelConverters.SINGLETON.skippedPackages.add("java.lang");
        ServiceLoader<ModelConverter> loader = ServiceLoader.load(ModelConverter.class);
        for (ModelConverter ext : loader) {
            if (ext == null) {
                LOGGER.error("failed to load extension " + ext);
                continue;
            }
            SINGLETON.addConverter(ext);
            LOGGER.debug("adding ModelConverter: " + ext);
        }
    }
}

