/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.SniHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AsyncMapping;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

class VertxSniHandler
extends SniHandler {
    private final Executor delegatedTaskExec;

    public VertxSniHandler(AsyncMapping<? super String, ? extends SslContext> mapping, long handshakeTimeoutMillis, Executor delegatedTaskExec) {
        super(mapping, handshakeTimeoutMillis);
        this.delegatedTaskExec = delegatedTaskExec;
    }

    protected SslHandler newSslHandler(SslContext context, ByteBufAllocator allocator) {
        SslHandler sslHandler = context.newHandler(allocator, this.delegatedTaskExec);
        sslHandler.setHandshakeTimeout(this.handshakeTimeoutMillis, TimeUnit.MILLISECONDS);
        return sslHandler;
    }
}

