/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.mrsid;

import it.geosolutions.imageio.gdalframework.GDALCommonIIOImageMetadata;
import it.geosolutions.imageio.gdalframework.GDALUtilities;
import java.util.Map;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public class MrSIDIIOImageMetadata
extends GDALCommonIIOImageMetadata {
    public static final String mrsidImageMetadataName = "org_gdal_imageio_mrsid_metadata";
    public static final String mrsidImageMetadataFormatClassName = "it.geosolutions.imageio.gdalframework.MrSIDIIOImageMetadataFormat";

    public MrSIDIIOImageMetadata(String dataseName) {
        super(dataseName, mrsidImageMetadataName, mrsidImageMetadataFormatClassName);
    }

    public Node getAsTree(String formatName) {
        if (formatName.equalsIgnoreCase(mrsidImageMetadataName)) {
            return this.getMrSIDMetadataTree();
        }
        return super.getAsTree(formatName);
    }

    private Node getMrSIDMetadataTree() {
        IIOMetadataNode root = new IIOMetadataNode(mrsidImageMetadataName);
        Map defaultDomainMap = this.getGdalMetadataDomain("");
        IIOMetadataNode node = new IIOMetadataNode("ImageDescriptor");
        node.setAttribute("IMAGE__INPUT_NAME", this.getDatasetName());
        GDALUtilities.setNodeAttribute((String)"IMAGE__INPUT_FILE_SIZE", defaultDomainMap.get("IMAGE__INPUT_FILE_SIZE"), (IIOMetadataNode)node, (int)4);
        GDALUtilities.setNodeAttribute((String)"IMAGE__DYNAMIC_RANGE_WINDOW", defaultDomainMap.get("IMAGE__DYNAMIC_RANGE_WINDOW"), (IIOMetadataNode)node, (int)4);
        GDALUtilities.setNodeAttribute((String)"IMAGE__DYNAMIC_RANGE_LEVEL", defaultDomainMap.get("IMAGE__DYNAMIC_RANGE_LEVEL"), (IIOMetadataNode)node, (int)4);
        GDALUtilities.setNodeAttribute((String)"IMAGE__COMPRESSION_VERSION", defaultDomainMap.get("IMAGE__COMPRESSION_VERSION"), (IIOMetadataNode)node, (int)4);
        GDALUtilities.setNodeAttribute((String)"IMAGE__TARGET_COMPRESSION_RATIO", defaultDomainMap.get("IMAGE__TARGET_COMPRESSION_RATIO"), (IIOMetadataNode)node, (int)4);
        GDALUtilities.setNodeAttribute((String)"IMAGE__COMPRESSION_NLEV", defaultDomainMap.get("IMAGE__COMPRESSION_NLEV"), (IIOMetadataNode)node, (int)4);
        GDALUtilities.setNodeAttribute((String)"IMAGE__COMPRESSION_WEIGHT", defaultDomainMap.get("IMAGE__COMPRESSION_WEIGHT"), (IIOMetadataNode)node, (int)4);
        GDALUtilities.setNodeAttribute((String)"IMAGE__COMPRESSION_GAMMA", defaultDomainMap.get("IMAGE__COMPRESSION_GAMMA"), (IIOMetadataNode)node, (int)4);
        GDALUtilities.setNodeAttribute((String)"IMAGE__COMPRESSION_BLOCK_SIZE", defaultDomainMap.get("IMAGE__COMPRESSION_BLOCK_SIZE"), (IIOMetadataNode)node, (int)2);
        GDALUtilities.setNodeAttribute((String)"IMAGE__CREATION_DATE", defaultDomainMap.get("IMAGE__CREATION_DATE"), (IIOMetadataNode)node, (int)0);
        GDALUtilities.setNodeAttribute((String)"IMAGE__WIDTH", defaultDomainMap.get("IMAGE__WIDTH"), (IIOMetadataNode)node, (int)2);
        GDALUtilities.setNodeAttribute((String)"IMAGE__HEIGHT", defaultDomainMap.get("IMAGE__HEIGHT"), (IIOMetadataNode)node, (int)2);
        GDALUtilities.setNodeAttribute((String)"IMAGE__TRANSPARENT_DATA_VALUE", defaultDomainMap.get("IMAGE__TRANSPARENT_DATA_VALUE"), (IIOMetadataNode)node, (int)0);
        GDALUtilities.setNodeAttribute((String)"IMAGE__COLOR_SCHEME", defaultDomainMap.get("IMAGE__COLOR_SCHEME"), (IIOMetadataNode)node, (int)2);
        GDALUtilities.setNodeAttribute((String)"IMAGE__DATA_TYPE", defaultDomainMap.get("IMAGE__DATA_TYPE"), (IIOMetadataNode)node, (int)2);
        GDALUtilities.setNodeAttribute((String)"IMAGE__BITS_PER_SAMPLE", defaultDomainMap.get("IMAGE__BITS_PER_SAMPLE"), (IIOMetadataNode)node, (int)2);
        root.appendChild(node);
        node = new IIOMetadataNode("Georeferencing");
        GDALUtilities.setNodeAttribute((String)"IMG__HORIZONTAL_UNITS", defaultDomainMap.get("IMG__HORIZONTAL_UNITS"), (IIOMetadataNode)node, (int)0);
        GDALUtilities.setNodeAttribute((String)"IMG__PROJECTION_TYPE", defaultDomainMap.get("IMG__PROJECTION_TYPE"), (IIOMetadataNode)node, (int)0);
        GDALUtilities.setNodeAttribute((String)"IMG__PROJECTION_NUMBER", defaultDomainMap.get("IMG__PROJECTION_NUMBER"), (IIOMetadataNode)node, (int)2);
        GDALUtilities.setNodeAttribute((String)"IMG__PROJECTION_ZONE", defaultDomainMap.get("IMG__PROJECTION_ZONE"), (IIOMetadataNode)node, (int)2);
        GDALUtilities.setNodeAttribute((String)"IMG__SPHEROID_NAME", defaultDomainMap.get("IMG__SPHEROID_NAME"), (IIOMetadataNode)node, (int)0);
        GDALUtilities.setNodeAttribute((String)"IMG__SPHEROID_SEMI_MAJOR_AXIS", defaultDomainMap.get("IMG__SPHEROID_SEMI_MAJOR_AXIS"), (IIOMetadataNode)node, (int)4);
        GDALUtilities.setNodeAttribute((String)"IMG__SPHEROID_SEMI_MINOR_AXIS", defaultDomainMap.get("IMG__SPHEROID_SEMI_MINOR_AXIS"), (IIOMetadataNode)node, (int)4);
        GDALUtilities.setNodeAttribute((String)"IMG__SPHEROID_ECCENTRICITY_SQUARED", defaultDomainMap.get("IMG__SPHEROID_ECCENTRICITY_SQUARED"), (IIOMetadataNode)node, (int)4);
        GDALUtilities.setNodeAttribute((String)"IMG__SPHEROID_RADIUS", defaultDomainMap.get("IMG__SPHEROID_RADIUS"), (IIOMetadataNode)node, (int)4);
        GDALUtilities.setNodeAttribute((String)"IMAGE__XY_ORIGIN", defaultDomainMap.get("IMAGE__XY_ORIGIN"), (IIOMetadataNode)node, (int)0);
        GDALUtilities.setNodeAttribute((String)"IMAGE__X_RESOLUTION", defaultDomainMap.get("IMAGE__X_RESOLUTION"), (IIOMetadataNode)node, (int)4);
        GDALUtilities.setNodeAttribute((String)"IMAGE__Y_RESOLUTION", defaultDomainMap.get("IMAGE__Y_RESOLUTION"), (IIOMetadataNode)node, (int)4);
        GDALUtilities.setNodeAttribute((String)"IMAGE__WKT", defaultDomainMap.get("IMAGE__WKT"), (IIOMetadataNode)node, (int)0);
        root.appendChild(node);
        return root;
    }

    public boolean isReadOnly() {
        return true;
    }

    public void mergeTree(String formatName, Node root) throws IIOInvalidTreeException {
        throw new UnsupportedOperationException("mergeTree operation is not allowed");
    }

    public void reset() {
        throw new UnsupportedOperationException("reset operation is not allowed");
    }
}

