/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.callback;

import javax.security.auth.callback.Callback;

public class ConfirmationCallback
implements Callback {
    public static final int UNSPECIFIED_OPTION = 0;
    public static final int YES_NO_OPTION = 1;
    public static final int YES_NO_CANCEL_OPTION = 2;
    public static final int OK_CANCEL_OPTION = 3;
    public static final int YES = 4;
    public static final int NO = 5;
    public static final int CANCEL = 6;
    public static final int OK = 7;
    public static final int INFORMATION = 8;
    public static final int WARNING = 9;
    public static final int ERROR = 10;
    private int messageType;
    private int optionType;
    private int defaultOption;
    private int selectedOption;
    private String[] options = null;
    private String prompt;

    public String getPrompt() {
        return this.prompt;
    }

    public int getOptionType() {
        if (this.options != null) {
            return 0;
        }
        return this.optionType;
    }

    public String[] getOptions() {
        return this.options;
    }

    public int getDefaultOption() {
        return this.defaultOption;
    }

    public void setSelectedIndex(int selection) {
        if (this.options != null) {
            this.setOptions(this.options, selection);
        } else {
            this.setOptionType(this.optionType, selection);
        }
    }

    public int getSelectedIndex() {
        return this.selectedOption;
    }

    private final void setMessageType(int messageType) throws IllegalArgumentException {
        switch (messageType) {
            case 8: 
            case 9: 
            case 10: {
                this.messageType = messageType;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal message type");
            }
        }
    }

    private final void setOptionType(int optionType, int selectedOption) throws IllegalArgumentException {
        block0 : switch (optionType) {
            case 1: {
                this.optionType = optionType;
                switch (selectedOption) {
                    case 4: 
                    case 5: {
                        this.selectedOption = selectedOption;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("invalid option");
            }
            case 2: {
                this.optionType = optionType;
                switch (selectedOption) {
                    case 4: 
                    case 5: 
                    case 6: {
                        this.selectedOption = selectedOption;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("invalid option");
            }
            case 3: {
                this.optionType = optionType;
                switch (selectedOption) {
                    case 6: 
                    case 7: {
                        this.selectedOption = selectedOption;
                        break block0;
                    }
                }
                throw new IllegalArgumentException("invalid option");
            }
            default: {
                throw new IllegalArgumentException("illegal option type");
            }
        }
    }

    private final void setOptions(String[] options, int selectedOption) throws IllegalArgumentException {
        if (selectedOption < 0 || selectedOption > options.length - 1) {
            throw new IllegalArgumentException("invalid default option");
        }
        if (options == null || options.length == 0) {
            throw new IllegalArgumentException("options is null or zero length");
        }
        int i = 0;
        while (i < options.length) {
            if (options[i] == null || options[i].length() == 0) {
                throw new IllegalArgumentException("options element " + i + "is null or zero length");
            }
            ++i;
        }
        this.options = options;
        this.selectedOption = selectedOption;
    }

    private final void setPrompt(String prompt) throws IllegalArgumentException {
        if (prompt == null || prompt.length() == 0) {
            throw new IllegalArgumentException("prompt is null or zero length");
        }
        this.prompt = prompt;
    }

    public ConfirmationCallback(int messageType, int optionType, int defaultOption) throws IllegalArgumentException {
        this.setMessageType(messageType);
        this.setOptionType(optionType, defaultOption);
        this.defaultOption = defaultOption;
    }

    public ConfirmationCallback(int messageType, String[] options, int defaultOption) {
        this.setMessageType(messageType);
        this.setOptions(options, defaultOption);
        this.defaultOption = defaultOption;
    }

    public ConfirmationCallback(String prompt, int messageType, int optionType, int defaultOption) {
        this.setPrompt(prompt);
        this.setMessageType(messageType);
        this.setOptionType(optionType, defaultOption);
        this.defaultOption = defaultOption;
    }

    public ConfirmationCallback(String prompt, int messageType, String[] options, int defaultOption) {
        this.setPrompt(prompt);
        this.setMessageType(messageType);
        this.setOptions(options, defaultOption);
        this.defaultOption = defaultOption;
    }
}

