/*
 * Decompiled with CFR 0.152.
 */
package javax.security.sasl;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;

public class Sasl {
    public static final String QOP = "javax.security.sasl.qop";
    public static final String STRENGTH = "javax.security.sasl.strength";
    public static final String SERVER_AUTH = "javax.security.sasl.server.authentication";
    public static final String MAX_BUFFER = "javax.security.sasl.maxbuffer";
    public static final String CLIENT_PKGS = "javax.security.sasl.client.pkgs";
    public static final String SERVER_PKGS = "javax.security.sasl.server.pkgs";
    public static final String RAW_SEND_SIZE = "javax.security.sasl.rawsendsize";
    public static final String POLICY_NOPLAINTEXT = "javax.security.sasl.policy.noplaintext";
    public static final String POLICY_NOACTIVE = "javax.security.sasl.policy.noactive";
    public static final String POLICY_NODICTIONARY = "javax.security.sasl.policy.nodictionary";
    public static final String POLICY_NOANONYMOUS = "javax.security.sasl.policy.noanonymous";
    public static final String POLICY_FORWARD_SECRECY = "javax.security.sasl.policy.forward";
    public static final String POLICY_PASS_CREDENTIALS = "javax.security.sasl.policy.credentials";
    private static SaslServerFactory serverFactory = null;
    private static SaslClientFactory clientFactory = null;

    public static SaslClient createSaslClient(String[] mechanisms, String authorizationID, String protocol, String serverName, Hashtable props, CallbackHandler cbh) throws SaslException {
        SaslClient client;
        if (clientFactory != null && (client = clientFactory.createSaslClient(mechanisms, authorizationID, protocol, serverName, props, cbh)) != null) {
            return client;
        }
        Enumeration clientFactoryPkgs = Sasl.getSaslClientFactories(props);
        while (clientFactoryPkgs.hasMoreElements()) {
            StringBuffer pkg = new StringBuffer((String)clientFactoryPkgs.nextElement());
            pkg.append(".ClientFactory");
            try {
                SaslClientFactory fac = (SaslClientFactory)Class.forName(pkg.toString()).newInstance();
                SaslClient client2 = fac.createSaslClient(mechanisms, authorizationID, protocol, serverName, props, cbh);
                if (client2 == null) continue;
                return client2;
            }
            catch (ClassCastException ignored) {
            }
            catch (ClassNotFoundException ignored) {
            }
            catch (InstantiationException ignored) {
            }
            catch (IllegalAccessException ignored) {
                // empty catch block
            }
        }
        return null;
    }

    public static void setSaslClientFactory(SaslClientFactory fac) {
        clientFactory = fac;
    }

    public static SaslServer createSaslServer(String mechanism, String protocol, String serverName, Hashtable props, CallbackHandler cbh) throws SaslException {
        SaslServer server;
        if (serverFactory != null && (server = serverFactory.createSaslServer(mechanism, protocol, serverName, props, cbh)) != null) {
            return server;
        }
        Enumeration serverFactoryPkgs = Sasl.getSaslServerFactories(props);
        while (serverFactoryPkgs.hasMoreElements()) {
            StringBuffer pkg = new StringBuffer((String)serverFactoryPkgs.nextElement());
            pkg.append(".ServerFactory");
            try {
                SaslServerFactory fac = (SaslServerFactory)Class.forName(pkg.toString()).newInstance();
                SaslServer server2 = fac.createSaslServer(mechanism, protocol, serverName, props, cbh);
                if (server2 == null) continue;
                return server2;
            }
            catch (ClassCastException ignored) {
            }
            catch (ClassNotFoundException ignored) {
            }
            catch (InstantiationException ignored) {
            }
            catch (IllegalAccessException ignored) {
                // empty catch block
            }
        }
        return null;
    }

    public static void setSaslServerFactory(SaslServerFactory fac) {
        serverFactory = fac;
    }

    public static Enumeration getSaslClientFactories(Hashtable props) {
        return Sasl.getFactories(CLIENT_PKGS, props);
    }

    public static Enumeration getSaslServerFactories(Hashtable props) {
        return Sasl.getFactories(SERVER_PKGS, props);
    }

    /*
     * WARNING - void declaration
     */
    private static final Enumeration getFactories(String propertyName, Hashtable props) {
        void pkgs;
        String string;
        Vector<String> factoryPkgs = new Vector<String>(5);
        String givenpkgs = null;
        if (props != null) {
            try {
                givenpkgs = (String)props.get(propertyName);
            }
            catch (ClassCastException ignored) {
                // empty catch block
            }
        }
        String syspkgs = System.getProperty(propertyName, null);
        if (givenpkgs != null && syspkgs != null) {
            string = givenpkgs + "|" + syspkgs;
        } else if (givenpkgs != null) {
            string = givenpkgs;
        } else if (syspkgs != null) {
            string = syspkgs;
        } else {
            return null;
        }
        StringTokenizer strtok = new StringTokenizer((String)pkgs, "|");
        while (strtok.hasMoreTokens()) {
            factoryPkgs.addElement(strtok.nextToken());
        }
        return factoryPkgs.elements();
    }

    private Sasl() {
    }
}

