/*
 * Decompiled with CFR 0.152.
 */
package scala_maven;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.maven.BuildFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.invoker.CommandLineConfigurationException;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.Invoker;
import org.apache.maven.shared.invoker.MavenCommandLineBuilder;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.shared.invoker.SystemOutHandler;
import org.codehaus.plexus.util.StringUtils;
import scala_maven.ScalaContinuousCompileMojo;

@Mojo(name="cctest", requiresDependencyResolution=ResolutionScope.TEST)
public class ScalaContinuousTestMojo
extends ScalaContinuousCompileMojo {
    @Component
    protected Invoker invoker;
    @Parameter(property="invoker.localRepositoryPath", defaultValue="${settings.localRepository}")
    protected File localRepositoryPath;
    @Parameter(property="test")
    protected String test;
    @Parameter(property="cctest.goals", defaultValue="surefire:test")
    protected String ccTestGoals;

    @Override
    protected void postCompileActions() throws Exception {
        if (this.test == null) {
            this.getLog().info((CharSequence)"Now running all the unit tests. Use -Dtest=FooTest to run a single test by name");
        } else {
            this.getLog().info((CharSequence)("Now running tests matching: " + this.test));
        }
        DefaultInvocationRequest request = new DefaultInvocationRequest();
        request.setLocalRepositoryDirectory(this.localRepositoryPath);
        request.setBatchMode(true);
        request.setErrorHandler((InvocationOutputHandler)new SystemOutHandler(true));
        request.setOutputHandler((InvocationOutputHandler)new SystemOutHandler(true));
        request.setBaseDirectory(this.project.getBasedir());
        request.setPomFile(new File(this.project.getBasedir(), "pom.xml"));
        request.setGoals(this.getMavenGoals());
        request.setOffline(false);
        if (this.test != null) {
            Properties properties = new Properties();
            properties.put("test", this.test);
            request.setProperties(properties);
        }
        if (this.getLog().isDebugEnabled()) {
            try {
                this.getLog().debug((CharSequence)("Executing: " + new MavenCommandLineBuilder().build((InvocationRequest)request)));
            }
            catch (CommandLineConfigurationException e) {
                this.getLog().debug((CharSequence)("Failed to display command line: " + e.getMessage()));
            }
        }
        try {
            this.invoker.execute((InvocationRequest)request);
        }
        catch (MavenInvocationException e) {
            this.getLog().debug((CharSequence)("Error invoking Maven: " + e.getMessage()), (Throwable)e);
            throw new BuildFailureException("Maven invocation failed. " + e.getMessage(), (Throwable)e);
        }
    }

    protected List<String> getMavenGoals() {
        this.getLog().debug((CharSequence)("Running tests with goal(s): " + this.ccTestGoals));
        return Arrays.asList(StringUtils.split((String)this.ccTestGoals, (String)" "));
    }
}

