/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.loadbalancer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.guerlab.loadbalancer.TargetWrapper;

public interface ILoadBalancer<T, C> {
    public static final int MIN_WEIGHT = 1;

    public void addTargetWrapper(TargetWrapper<T> var1);

    default public void addTarget(T target, Boolean initActive) {
        if (target == null) {
            return;
        }
        TargetWrapper<T> wrapper = TargetWrapper.of(target);
        if (initActive != null) {
            wrapper.setActive(initActive);
        }
        this.addTargetWrapper(wrapper);
    }

    default public void addTarget(T target) {
        this.addTarget(target, null);
    }

    default public void addTargetWrappers(Collection<TargetWrapper<T>> wrappers) {
        if (wrappers == null || wrappers.isEmpty()) {
            return;
        }
        wrappers.forEach(this::addTargetWrapper);
    }

    default public void addTargets(Collection<T> targets, Boolean initActive) {
        if (targets == null || targets.isEmpty()) {
            return;
        }
        ArrayList<TargetWrapper<T>> wrappers = new ArrayList<TargetWrapper<T>>(targets.size());
        for (T target : targets) {
            if (target == null) continue;
            TargetWrapper<T> wrapper = TargetWrapper.of(target);
            if (initActive != null) {
                wrapper.setActive(initActive);
            }
            wrappers.add(wrapper);
        }
        this.addTargetWrappers(wrappers);
    }

    default public void addTargets(Collection<T> targets) {
        this.addTargets(targets, null);
    }

    public void removeTargetWrapper(TargetWrapper<T> var1);

    default public void removeTarget(T target) {
        if (target == null) {
            return;
        }
        this.removeTargetWrapper(TargetWrapper.of(target));
    }

    default public void removeTargetWrappers(Collection<TargetWrapper<T>> wrappers) {
        if (wrappers == null || wrappers.isEmpty()) {
            return;
        }
        wrappers.forEach(this::removeTargetWrapper);
    }

    default public void removeTargets(Collection<T> targets) {
        if (targets == null || targets.isEmpty()) {
            return;
        }
        Collection wrappers = targets.stream().filter(Objects::nonNull).map(TargetWrapper::of).collect(Collectors.toList());
        this.removeTargetWrappers(wrappers);
    }

    public void clear();

    public void setWeight(T var1, int var2);

    public T choose(Predicate<? super T> var1, C var2);

    default public T choose(C chooseReferenceObject) {
        return this.choose(null, chooseReferenceObject);
    }

    default public T choose() {
        return this.choose(null, null);
    }

    public void markReachable(TargetWrapper<T> var1);

    default public void markReachable(T target) {
        if (target == null) {
            return;
        }
        this.markReachable((T)TargetWrapper.of(target));
    }

    public void markDown(TargetWrapper<T> var1);

    default public void markDown(T target) {
        if (target == null) {
            return;
        }
        this.markDown((T)TargetWrapper.of(target));
    }

    public List<TargetWrapper<T>> getTargetWrappers(Boolean var1);

    public List<T> getTargets(Boolean var1);
}

