/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.loadbalancer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.guerlab.loadbalancer.AbstractLoadBalancer;
import net.guerlab.loadbalancer.TargetWrapper;

public class WeightRoundRobinLoadBalancer<T, C>
extends AbstractLoadBalancer<T, C> {
    private final Map<T, Integer> weightMap = new ConcurrentHashMap<T, Integer>();
    private final Lock lock = new ReentrantLock();
    private int position = 0;

    public WeightRoundRobinLoadBalancer() {
    }

    public WeightRoundRobinLoadBalancer(List<TargetWrapper<T>> targetList) {
        super(targetList);
    }

    @Override
    protected void afterAdd(TargetWrapper<T> wrapper) {
        this.weightMap.put(wrapper.getTarget(), 1);
    }

    @Override
    protected void afterRemove(TargetWrapper<T> wrapper) {
        this.weightMap.remove(wrapper.getTarget());
    }

    @Override
    public void setWeight(T target, int weight) {
        if (target == null) {
            return;
        }
        this.weightMap.put(target, Math.max(weight, 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected T choose0(List<TargetWrapper<T>> activeTargetList, C chooseReferenceObject) {
        ArrayList<TargetWrapper<T>> targetList = new ArrayList<TargetWrapper<T>>();
        for (TargetWrapper<T> targetWrapper : activeTargetList) {
            int weight = this.weightMap.getOrDefault(targetWrapper.getTarget(), 1);
            for (int i = 0; i < weight; ++i) {
                targetList.add(targetWrapper);
            }
        }
        int size = targetList.size();
        this.lock.lock();
        try {
            if (this.position >= size) {
                this.position = 0;
            }
            TargetWrapper targetWrapper = (TargetWrapper)targetList.get(this.position);
            ++this.position;
            T t = targetWrapper == null ? null : (T)targetWrapper.getTarget();
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }
}

