/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.intelie.pipes.AbstractRawEvent;
import net.intelie.pipes.util.Preconditions;

public class ArrayRawEvent
extends AbstractRawEvent {
    private static final long serialVersionUID = 1L;
    private final List values;

    public ArrayRawEvent(List values) {
        Preconditions.checkNotNull(values, "values array cannot be null");
        this.values = values;
    }

    public static ArrayRawEvent fromArray(Object ... values) {
        return new ArrayRawEvent(Arrays.asList(values));
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public Object get(int i) {
        if (i < 0 || i >= this.values.size()) {
            return null;
        }
        return this.values.get(i);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.values.iterator();
    }
}

