/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes;

import net.intelie.pipes.AbstractRow;
import net.intelie.pipes.Row;
import net.intelie.pipes.util.Preconditions;

public class ArrayRow
extends AbstractRow {
    private static final long serialVersionUID = 1L;
    private final Object[] values;

    public ArrayRow(Object ... values) {
        Preconditions.checkNotNull(values, "values array cannot be null");
        this.values = values;
    }

    public static ArrayRow concat(Row ... rows) {
        int size = 0;
        for (Row row : rows) {
            size += row.size();
        }
        Object[] newValues = new Object[size];
        int i = 0;
        for (Row row : rows) {
            int thisSize = row.size();
            for (int j = 0; j < thisSize; ++j) {
                newValues[i++] = row.get(j);
            }
        }
        return new ArrayRow(newValues);
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public Object get(int index) {
        return this.values[index];
    }
}

