/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes;

import java.util.ArrayDeque;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.Tree;

public class AutoFullMerger
implements FullMerger {
    private final ArrayDeque<Tree> back = new ArrayDeque();
    private final ArrayDeque<Tree> backSum = new ArrayDeque();
    private final ArrayDeque<Tree> frontSum = new ArrayDeque();
    private final InsertMerger merger;

    public AutoFullMerger(InsertMerger merger) {
        this.merger = merger;
    }

    public long size() {
        return this.back.size() + this.frontSum.size();
    }

    @Override
    public void pop() {
        if (this.frontSum.isEmpty() && this.backSum.isEmpty()) {
            return;
        }
        if (this.frontSum.isEmpty()) {
            this.merger.clear();
            while (!this.back.isEmpty()) {
                this.merger.push(this.back.pollLast());
                this.frontSum.addLast(this.merger.get());
            }
            this.backSum.clear();
            this.merger.clear();
        }
        this.frontSum.pollLast();
    }

    @Override
    public void push(Tree tree) {
        this.back.addLast(tree);
        this.merger.push(tree);
        this.backSum.addLast(this.merger.get());
    }

    @Override
    public void clear() {
        this.back.clear();
        this.backSum.clear();
        this.frontSum.clear();
        this.merger.clear();
    }

    @Override
    public Tree get() {
        if (!this.frontSum.isEmpty()) {
            this.merger.push(this.frontSum.peekLast());
        }
        Tree tree = this.merger.get();
        this.merger.clear();
        if (!this.backSum.isEmpty()) {
            this.merger.push(this.backSum.peekLast());
        }
        return tree;
    }
}

