/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes;

import net.intelie.pipes.Tree;
import net.intelie.pipes.util.TreeQueue;

public interface FullMerger {
    public void pop();

    public void push(Tree var1);

    public void clear();

    public Tree get();

    public static void popMany(FullMerger[] mergers) {
        for (int i = 0; i < mergers.length; ++i) {
            mergers[i].pop();
        }
    }

    public static abstract class Queued<Q extends Tree>
    implements FullMerger {
        private final TreeQueue queue = new TreeQueue(16);

        @Override
        public void push(Tree tree) {
            this.queue.enqueue(tree);
            this.pushQ(tree);
        }

        @Override
        public void pop() {
            if (!this.queue.isEmpty()) {
                this.popQ(this.queue.dequeue());
            }
        }

        @Override
        public void clear() {
            this.queue.clear();
            this.clearQ();
        }

        public abstract void pushQ(Q var1);

        public abstract void popQ(Q var1);

        public abstract void clearQ();

        public abstract Q get();
    }

    public static abstract class Base<Q extends Tree>
    implements FullMerger {
        @Override
        public void push(Tree tree) {
            this.pushQ(tree);
        }

        public abstract void pushQ(Q var1);

        public abstract Q get();
    }
}

