/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes;

import java.io.Serializable;
import java.util.Objects;

public class HelpData
implements Serializable {
    public static final HelpData EMPTY = new HelpData(null, null, null, null, null, null, null, null);
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String name;
    private final String usage;
    private final String description;
    private final String since;
    private final String docKey;
    private final String docUrl;
    private final String text;

    public HelpData(String type, String name, String usage, String description, String since, String docKey, String docUrl, String text) {
        if (type == null) {
            type = HelpData.typeByName(name);
        }
        String[] descs = description != null ? description.split("[\\r\\n]", 2) : new String[]{};
        String maybeText = ((descs.length > 1 ? descs[1] : "").trim() + (text != null ? "\n\n" + text.trim() : "")).trim();
        this.type = type;
        this.name = name;
        this.usage = usage;
        this.description = descs.length > 0 ? descs[0].trim() : null;
        this.since = since;
        this.docKey = docKey;
        this.docUrl = docUrl;
        this.text = !maybeText.isEmpty() ? maybeText : null;
    }

    public static String typeByName(String name) {
        if (name == null) {
            return null;
        }
        return name.startsWith("@@") ? "macro" : (name.startsWith("@") ? "pipe" : "function");
    }

    public static HelpData merge(String name, HelpData a, HelpData b) {
        return new HelpData(HelpData.first(a.type(), b.type()), name, HelpData.first(a.usage(), b.usage()), HelpData.first(a.description(), b.description()), HelpData.first(a.since(), b.since()), HelpData.first(a.docKey(), b.docKey()), HelpData.first(a.docUrl(), b.docUrl()), HelpData.first(a.text(), b.text()));
    }

    private static String first(String a, String b) {
        if (a != null && !a.isEmpty()) {
            return a;
        }
        return b;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String usage() {
        return this.usage;
    }

    public String description() {
        return this.description;
    }

    public String since() {
        return this.since;
    }

    public String docKey() {
        return this.docKey;
    }

    public String docUrl() {
        return this.docUrl;
    }

    public String text() {
        return this.text;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HelpData that = (HelpData)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.name, that.name) && Objects.equals(this.usage, that.usage) && Objects.equals(this.description, that.description) && Objects.equals(this.since, that.since) && Objects.equals(this.docKey, that.docKey) && Objects.equals(this.text, that.text) && Objects.equals(this.docUrl, that.docUrl);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.name, this.usage, this.description, this.since, this.docKey, this.docUrl, this.text);
    }

    public String toString() {
        return "HelpData{type='" + this.type + '\'' + ", name='" + this.name + '\'' + ", usage='" + this.usage + '\'' + ", description='" + this.description + '\'' + ", since='" + this.since + '\'' + ", docKey='" + this.docKey + '\'' + ", docUrl='" + this.docUrl + '\'' + ", text='" + this.text + '\'' + '}';
    }
}

