/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes;

import java.util.Map;
import net.intelie.pipes.Aggregation;
import net.intelie.pipes.ArgQueue;
import net.intelie.pipes.EmptyMerger;
import net.intelie.pipes.FullMerger;
import net.intelie.pipes.Help;
import net.intelie.pipes.InsertMerger;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.PropertySink;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scalar;
import net.intelie.pipes.Scope;
import net.intelie.pipes.State;
import net.intelie.pipes.Tree;
import net.intelie.pipes.ValidationContext;
import net.intelie.pipes.WindowBounds;
import net.intelie.pipes.time.Period;
import net.intelie.pipes.types.Level;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.LiteralRepresentation;

@Help(omit=true)
public class Literal<T>
implements Scalar<T>,
Aggregation<T> {
    private static final long serialVersionUID = 1L;
    private final Type<T> type;
    private final T value;
    private final String description;

    public Literal(ArgQueue queue) throws PipeException {
        this(queue.get(Type.class), queue.getOptional());
    }

    public Literal(Type<T> type, Object value) {
        this(type, value, LiteralRepresentation.toString(type, value));
    }

    public Literal(Type<T> type, Object value, String description) {
        this.type = type;
        this.value = type.cast(value);
        this.description = description;
    }

    public static Literal<?> newAuto(Object value) {
        return new Literal(Type.infer(value), value);
    }

    public static Literal<Double> newNumber(Object value) {
        return new Literal<Double>(Type.NUMBER, value);
    }

    public static Literal<String> newString(Object value) {
        return new Literal<String>(Type.STRING, value);
    }

    public static Literal<Object> newObject(Object value) {
        return new Literal<Object>(Type.OBJECT, value);
    }

    public static Literal<Boolean> newBoolean(Object value) {
        return new Literal<Boolean>(Type.BOOLEAN, value);
    }

    public static Literal<Object> newNull() {
        return new Literal<Object>(Type.NULL, null);
    }

    @Override
    public T eval(Scope parent, Object obj) {
        return this.value;
    }

    @Override
    public Type<T> type() {
        return this.type;
    }

    @Override
    public Level level() {
        return Level.CONSTANT;
    }

    public T value() {
        return this.value;
    }

    @Override
    public long ttl() {
        return 1L;
    }

    @Override
    public long weight() {
        return 0L;
    }

    @Override
    public void validate(ValidationContext context) throws PipeException {
    }

    public String toString() {
        return this.description;
    }

    @Override
    public State newState(int flips) {
        return new MyState();
    }

    @Override
    public FullMerger newMerger() {
        return new EmptyMerger();
    }

    @Override
    public InsertMerger newInsertMerger() {
        return new EmptyMerger();
    }

    @Override
    public T eval(Scope parent, Tree tree, WindowBounds bounds) {
        return this.value;
    }

    @Override
    public PropertyVisitor visit(Scope parent, PropertyVisitor visitor) {
        return Literal.visitLiteral(parent, visitor, this.value);
    }

    private static PropertyVisitor visitLiteral(Scope parent, PropertyVisitor visitor, Object value) {
        if (value == null || value instanceof Number || value instanceof String || value instanceof Boolean || value instanceof Period) {
            return visitor;
        }
        if (value instanceof PropertySink) {
            return ((PropertySink)value).visit(parent, visitor);
        }
        if (value instanceof Iterable) {
            for (Object obj : (Iterable)value) {
                Literal.visitLiteral(parent, visitor, obj);
            }
            return visitor.newScope();
        }
        if (value instanceof Map) {
            for (Map.Entry entry : ((Map)value).entrySet()) {
                Literal.visitLiteral(parent, visitor, entry.getKey());
                Literal.visitLiteral(parent, visitor, entry.getValue());
            }
            return visitor.newScope();
        }
        return visitor.unknown(value);
    }

    private class MyState
    implements State {
        private MyState() {
        }

        @Override
        public void yield(Scope parent, Object obj) {
        }

        @Override
        public Tree flip() {
            return null;
        }
    }
}

