/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes;

import java.io.Serializable;
import java.util.Objects;

public class ModuleContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String displayName;
    private final String url;

    public ModuleContext() {
        this("");
    }

    public ModuleContext(String name) {
        this(name, name);
    }

    public ModuleContext(String name, String displayName) {
        this(name, displayName, null);
    }

    public ModuleContext(String name, String displayName, String url) {
        this.name = name;
        this.displayName = displayName;
        this.url = url;
    }

    public static String prefixName(String prefix, String name) {
        if (prefix == null || prefix.isEmpty()) {
            return name;
        }
        if (name == null || name.isEmpty()) {
            return prefix;
        }
        StringBuilder pipePrefix = new StringBuilder();
        while (pipePrefix.length() < name.length() && name.charAt(pipePrefix.length()) == '@') {
            pipePrefix.append('@');
        }
        return pipePrefix.toString() + prefix + "." + name.substring(pipePrefix.length());
    }

    public boolean isDefault() {
        return this.name == null || this.name.isEmpty();
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getUrl() {
        return this.url;
    }

    public String resolveName(String name) {
        return ModuleContext.prefixName(this.name, name);
    }

    public String augmentDescription(String description) {
        if (Objects.equals(this.name, this.displayName)) {
            return description;
        }
        return "(module '" + this.displayName + "') " + description;
    }
}

