/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.intelie.pipes.Hintable;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.Property;
import net.intelie.pipes.PropertySink;
import net.intelie.pipes.PropertySource;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scope;
import net.intelie.pipes.filters.ObjectSink;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.Escapes;
import net.intelie.pipes.util.Iterables;
import net.intelie.pipes.util.Preconditions;

public class PropertyGroup
implements Serializable,
PropertySink {
    private static final long serialVersionUID = 1L;
    private final List<Property> properties;
    private final Type type;
    private final List<String> propertyNames;

    public PropertyGroup(PropertySource src, Type type, String ... properties) throws PipeException {
        this(src, type, Arrays.asList(properties));
    }

    public PropertyGroup(PropertySource src, Type type, List<String> properties) throws PipeException {
        this(PropertyGroup.makeProperties(src, type, properties));
    }

    public PropertyGroup(Property property) {
        this(Collections.singletonList(property));
    }

    private PropertyGroup(List<Property> properties) {
        Preconditions.checkArgument(properties.size() > 0, "must have some property");
        this.properties = properties;
        this.type = properties.get(properties.size() - 1).type();
        this.propertyNames = new ArrayList<String>(properties.size());
        for (Property property : properties) {
            this.propertyNames.add(property.name());
        }
    }

    private static List<Property> makeProperties(PropertySource src, Type type, List<String> properties) throws PipeException {
        ArrayList<Property> list = new ArrayList<Property>(properties.size());
        for (int i = 0; i < properties.size(); ++i) {
            String propertyName = properties.get(i);
            Hintable property = src.property(propertyName);
            if (i < properties.size() - 1) {
                property = property.hint((Type)Type.OBJECT);
            } else if (type != null || !Type.STRING.equals(property.type()) && !Type.NUMBER.equals(property.type())) {
                property = property.hint(type);
            }
            list.add((Property)property);
            src = src.newSource(src.metadata().withType(property.type()));
        }
        return list;
    }

    public Type type() {
        return this.type;
    }

    public List<String> propertyNames() {
        return Collections.unmodifiableList(this.propertyNames);
    }

    public String firstProperty() {
        return this.properties.get(0).name();
    }

    public boolean isProperty(String name) {
        return this.properties.size() == 1 && Objects.equals(this.firstProperty(), name);
    }

    public String toString() {
        return this.type().makeString(this.displayName());
    }

    public String displayName() {
        ArrayList<String> parts = new ArrayList<String>(this.properties.size());
        for (Property property : this.properties) {
            parts.add(Escapes.formatIdentifier(property.name()));
        }
        return Iterables.join("->", parts);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyGroup that = (PropertyGroup)o;
        Iterator<Property> it1 = this.properties.iterator();
        Iterator<Property> it2 = that.properties.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            if (Objects.equals(it1.next().name(), it2.next().name())) continue;
            return false;
        }
        return it1.hasNext() == it2.hasNext() && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        int hash = this.type.hashCode();
        for (Property property : this.properties) {
            hash *= 31;
            hash += Objects.hash(property.name());
        }
        return hash;
    }

    public void evalRaw(Scope scope, Object obj, ObjectSink sink) {
        for (int i = 0; i < this.properties.size() - 1; ++i) {
            Property property = this.properties.get(i);
            Object obj2 = property.eval(scope, obj);
            scope = new Scope(scope, obj);
            obj = obj2;
        }
        this.properties.get(this.properties.size() - 1).evalRaw(scope, obj, sink);
    }

    @Override
    public PropertyVisitor visit(Scope scope, PropertyVisitor visitor) {
        for (Property property : this.properties) {
            PropertyVisitor visitor2 = property.visit(scope, visitor);
            scope = new Scope(scope, visitor);
            visitor = visitor2;
        }
        return visitor;
    }
}

