/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Objects;
import net.intelie.pipes.util.Preconditions;

public class Scope
implements Iterable<Object>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Scope parent;
    private final Object object;

    public Scope(Object object) {
        this(null, object);
    }

    public Scope(Scope parent, Object object) {
        this.parent = parent;
        this.object = object;
    }

    public Scope parent() {
        return this.parent;
    }

    public Object object() {
        return this.object;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Scope)) {
            return false;
        }
        Scope scope = (Scope)o;
        return Objects.equals(this.parent, scope.parent) && Objects.equals(this.object, scope.object);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.object);
    }

    public String toString() {
        if (this.parent != null) {
            return this.parent + "->" + this.object;
        }
        return String.valueOf(this.object);
    }

    public Object get(int depth) {
        if (depth == 0) {
            return this.object;
        }
        if (this.parent == null || depth < 0) {
            return null;
        }
        return this.parent.get(depth - 1);
    }

    @Override
    public Iterator<Object> iterator() {
        return new MyIterator();
    }

    private class MyIterator
    implements Iterator<Object>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Scope current;

        private MyIterator() {
            this.current = Scope.this;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public Object next() {
            Preconditions.checkState(this.hasNext(), "no more elements to iterate");
            Object obj = this.current.object;
            this.current = this.current.parent;
            return obj;
        }
    }
}

