/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes;

import java.util.Arrays;
import net.intelie.pipes.ArrayRow;
import net.intelie.pipes.UnsafeObject;

public final class UnsafeRow
implements UnsafeObject<UnsafeRow> {
    private final Object[] buffer;

    public UnsafeRow(int size) {
        this(new Object[size]);
    }

    private UnsafeRow(Object[] buffer) {
        this.buffer = buffer;
    }

    public Object get(int id) {
        return this.buffer[id];
    }

    public void set(int id, Object obj) {
        this.buffer[id] = obj;
    }

    @Override
    public UnsafeRow copy() {
        return new UnsafeRow(Arrays.copyOf(this.buffer, this.buffer.length));
    }

    public ArrayRow toRow() {
        return new ArrayRow(Arrays.copyOf(this.buffer, this.buffer.length));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnsafeRow)) {
            return false;
        }
        UnsafeRow row = (UnsafeRow)o;
        return Arrays.equals(this.buffer, row.buffer);
    }

    public int hashCode() {
        return Arrays.hashCode(this.buffer);
    }

    public String toString() {
        return "" + Arrays.asList(this.buffer);
    }
}

