/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.ast;

import java.util.ArrayList;
import java.util.List;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.ast.AstNode;
import net.intelie.pipes.ast.CallNode;
import net.intelie.pipes.ast.LiteralNode;
import net.intelie.pipes.ast.PropertyNode;
import net.intelie.pipes.ast.RawNode;

public abstract class AstVisitor<T> {
    public T visit(AstNode node) throws PipeException {
        if (node == null) {
            return this.visitNull();
        }
        if (node instanceof CallNode) {
            return this.visitCall((CallNode)node);
        }
        if (node instanceof LiteralNode) {
            return this.visitLiteral((LiteralNode)node);
        }
        if (node instanceof PropertyNode) {
            return this.visitProperty((PropertyNode)node);
        }
        if (node instanceof RawNode) {
            return this.visitRaw((RawNode)node);
        }
        return this.visitUnknown(node);
    }

    public List<T> visitList(List<AstNode> nodes) throws PipeException {
        ArrayList<T> list = new ArrayList<T>();
        for (AstNode node : nodes) {
            list.add(this.visit(node));
        }
        return list;
    }

    public T visitUnknown(AstNode node) throws PipeException {
        throw new PipeException("Unknown node type: %s", node);
    }

    public T visitNull() throws PipeException {
        return null;
    }

    public abstract T visitRaw(RawNode var1) throws PipeException;

    public abstract T visitProperty(PropertyNode var1) throws PipeException;

    public abstract T visitLiteral(LiteralNode var1) throws PipeException;

    public abstract T visitCall(CallNode var1) throws PipeException;
}

