/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.ast;

import java.util.ArrayList;
import java.util.List;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.ast.AstNode;
import net.intelie.pipes.ast.AstVisitor;
import net.intelie.pipes.ast.CallNode;
import net.intelie.pipes.ast.LiteralNode;
import net.intelie.pipes.ast.PropertyNode;
import net.intelie.pipes.ast.RawNode;

public class AstVisitorBase
extends AstVisitor<AstNode> {
    @Override
    public List<AstNode> visitList(List<AstNode> nodes) throws PipeException {
        List<AstNode> list = null;
        for (int i = 0; i < nodes.size(); ++i) {
            AstNode node = nodes.get(i);
            List<AstNode> expanded = this.visitExpanding(node);
            if (expanded != null) {
                if (list == null) {
                    list = new ArrayList<AstNode>(nodes.subList(0, i));
                }
                list.addAll(expanded);
                continue;
            }
            AstNode visited = (AstNode)this.visit(node);
            if (node == visited && list == null) continue;
            if (list == null) {
                list = new ArrayList<AstNode>(nodes.subList(0, i));
            }
            list.add(visited);
        }
        return list != null ? list : nodes;
    }

    public List<AstNode> visitExpanding(AstNode node) throws PipeException {
        return null;
    }

    @Override
    public AstNode visitRaw(RawNode node) {
        return node;
    }

    @Override
    public AstNode visitProperty(PropertyNode node) throws PipeException {
        List<AstNode> newChildren;
        List<AstNode> children = node.getArgs();
        if (children == (newChildren = this.visitList(children))) {
            return node;
        }
        return new PropertyNode(node.getLocation(), node.getTarget(), node.getName(), node.hasArgs(), newChildren);
    }

    @Override
    public AstNode visitLiteral(LiteralNode node) {
        return node;
    }

    @Override
    public AstNode visitCall(CallNode node) throws PipeException {
        List<AstNode> newChildren;
        List<AstNode> children = node.getArgs();
        if (children == (newChildren = this.visitList(children))) {
            return node;
        }
        return new CallNode(node.getLocation(), node.getName(), newChildren);
    }
}

