/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.ast;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.intelie.pipes.ast.AstNode;
import net.intelie.pipes.ast.SourceAwareNode;
import net.intelie.pipes.ast.SourceLocation;
import net.intelie.pipes.util.Iterables;
import net.intelie.pipes.util.Preconditions;

public class CallNode
implements SourceAwareNode {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<AstNode> children;
    private final SourceLocation location;
    private final int _hash;

    public CallNode(SourceLocation location, String name, AstNode ... children) {
        this(location, name, Arrays.asList(children));
    }

    public CallNode(SourceLocation location, String name, List<? extends AstNode> children) {
        Preconditions.checkArgument(!".property".equals(name), "For property access, use PropertyNode");
        this.location = location;
        this.name = name;
        this.children = new ArrayList<AstNode>(children);
        this._hash = Objects.hash(this.name, this.children);
    }

    public String getName() {
        return this.name;
    }

    public List<AstNode> getArgs() {
        return this.children;
    }

    @Override
    public SourceLocation getLocation() {
        return this.location;
    }

    public String toString() {
        return this.name + "(" + Iterables.join(", ", this.children) + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CallNode that = (CallNode)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.children, that.children);
    }

    public int hashCode() {
        return this._hash;
    }
}

