/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.ast;

import java.util.Objects;
import net.intelie.pipes.ast.AstNode;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.LiteralRepresentation;

public class LiteralNode
implements AstNode {
    private static final long serialVersionUID = 1L;
    private final Type<?> type;
    private final Object value;
    private final int _hash;

    public LiteralNode(Type<?> type, Object value) {
        this.type = type;
        this.value = value;
        this._hash = Objects.hash(this.type, this.value);
    }

    public static LiteralNode newNumber(Object value) {
        return new LiteralNode(Type.NUMBER, value);
    }

    public static LiteralNode newString(Object value) {
        return new LiteralNode(Type.STRING, value);
    }

    public static LiteralNode newObject(Object value) {
        return new LiteralNode(Type.OBJECT, value);
    }

    public static LiteralNode newBoolean(Object value) {
        return new LiteralNode(Type.BOOLEAN, value);
    }

    public static LiteralNode newNull() {
        return new LiteralNode(Type.NULL, null);
    }

    public static LiteralNode newAuto(Object value) {
        return new LiteralNode(Type.infer(value), value);
    }

    public Type<?> getType() {
        return this.type;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return LiteralRepresentation.toString(this.type, this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LiteralNode that = (LiteralNode)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return this._hash;
    }
}

