/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.ast;

import java.io.Serializable;
import java.util.Objects;
import net.intelie.pipes.ast.AstNode;
import net.intelie.pipes.ast.SourceAwareNode;

public class SourceLocation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int line;
    private final int column;

    public SourceLocation(int line, int column) {
        this.line = line;
        this.column = column;
    }

    public static SourceLocation maybeGetFrom(AstNode node) {
        if (node instanceof SourceAwareNode) {
            return ((SourceAwareNode)node).getLocation();
        }
        return null;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String toString() {
        return this.line + ", " + this.column;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceLocation that = (SourceLocation)o;
        return Objects.equals(this.line, that.line) && Objects.equals(this.column, that.column);
    }

    public int hashCode() {
        return Objects.hash(this.line, this.column);
    }
}

