/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.cron;

import java.time.temporal.Temporal;
import java.time.temporal.ValueRange;
import java.util.Objects;
import net.intelie.pipes.cron.CronException;
import net.intelie.pipes.cron.Field;
import net.intelie.pipes.cron.FieldType;

public class RangeField
implements Field {
    private static final long serialVersionUID = 1L;
    private final FieldType field;
    private final int start;
    private final int end;
    private final int step;

    public RangeField(FieldType field, Integer start, Integer end, Integer step) {
        this.field = field;
        ValueRange range = field.range();
        CronException.check(start == null || (long)start.intValue() >= range.getMinimum() && (long)start.intValue() <= range.getMaximum(), "Invalid value: %d (allowed %s)", start, range);
        CronException.check(end == null || (long)end.intValue() >= range.getMinimum() && (long)end.intValue() <= range.getMaximum(), "Invalid value: %d (allowed %s)", start, range);
        CronException.check(end == null || start == null || start <= end, "Interval end must be >= start (%d > %d)", start, end);
        this.step = step != null ? step : 1;
        this.start = start != null ? start : (int)range.getMinimum();
        this.end = end != null ? this.roundDown(end) : (int)range.getMaximum();
    }

    private int roundUp(int current) {
        return this.roundDown(current + this.step - 1);
    }

    private int roundDown(int current) {
        return (current - this.start % this.step) / this.step * this.step + this.start % this.step;
    }

    @Override
    public boolean matches(Temporal date) {
        int current = this.field.get(date);
        return this.roundUp(current) == current && current >= this.start && current <= this.end;
    }

    @Override
    public <T extends Temporal & Comparable<? super T>> T nextOrSame(T date) {
        if (date == null) {
            return null;
        }
        if (this.matches(date)) {
            return date;
        }
        while (!this.matches(date)) {
            int current = this.field.get(date);
            ValueRange range = this.field.range(date);
            int min = Math.max(this.start, this.roundUp((int)range.getMinimum()));
            int max = Math.min(this.end, this.roundDown((int)range.getMaximum()));
            int proposed = this.roundUp(current);
            if (proposed < min) {
                date = this.field.add(date, min - current);
                continue;
            }
            if (proposed <= max) {
                date = this.field.add(date, proposed - current);
                continue;
            }
            date = this.field.add(date, range.getMaximum() - (long)current + 1L);
        }
        return this.field.clearToMin(date);
    }

    @Override
    public <T extends Temporal & Comparable<? super T>> T prevOrSame(T date) {
        if (date == null) {
            return null;
        }
        if (this.matches(date)) {
            return date;
        }
        while (!this.matches(date)) {
            int current = this.field.get(date);
            ValueRange range = this.field.range(date);
            int min = Math.max(this.start, this.roundUp((int)range.getMinimum()));
            int max = Math.min(this.end, this.roundDown((int)range.getMaximum()));
            int proposed = this.roundDown(current);
            if (proposed > max) {
                date = this.field.add(date, max - proposed);
                continue;
            }
            if (proposed >= min) {
                date = this.field.add(date, proposed - current);
                continue;
            }
            date = this.field.add(date, range.getMinimum() - (long)current - 1L);
        }
        return this.field.clearToMax(date);
    }

    public String toString() {
        return this.start + "-" + this.end + (this.step != 1 ? "/" + this.step : "");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RangeField that = (RangeField)o;
        return this.end == that.end && this.start == that.start && this.step == that.step && this.field == that.field;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.field, this.start, this.end, this.step});
    }
}

