/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.cron;

import java.time.temporal.Temporal;
import java.time.temporal.ValueRange;
import java.util.Objects;
import net.intelie.pipes.cron.CronException;
import net.intelie.pipes.cron.Field;
import net.intelie.pipes.cron.FieldType;

public class ValueField
implements Field {
    private static final long serialVersionUID = 1L;
    private final FieldType field;
    private final int value;

    public ValueField(FieldType field, int value) {
        ValueRange range = field.range();
        CronException.check((long)value >= range.getMinimum() && (long)value <= range.getMaximum(), "Invalid value: %d (allowed %s)", value, range);
        this.field = field;
        this.value = value;
    }

    @Override
    public boolean matches(Temporal date) {
        return this.field.get(date) == this.value;
    }

    @Override
    public <T extends Temporal & Comparable<? super T>> T nextOrSame(T date) {
        if (date == null) {
            return null;
        }
        int current = this.field.get(date);
        if (current == this.value) {
            return date;
        }
        while (current != this.value) {
            date = this.tryNext(date, this.value, current);
            current = this.field.get(date);
        }
        return this.field.clearToMin(date);
    }

    @Override
    public <T extends Temporal & Comparable<? super T>> T prevOrSame(T date) {
        if (date == null) {
            return null;
        }
        int current = this.field.get(date);
        if (current == this.value) {
            return date;
        }
        while (current != this.value) {
            date = this.tryPrevious(date, this.value, current);
            current = this.field.get(date);
        }
        return this.field.clearToMax(date);
    }

    private <T extends Temporal> T tryNext(T date, int value, int current) {
        if (current < value) {
            return this.field.add(date, value - current);
        }
        ValueRange range = this.field.range(date);
        return this.field.add(date, (long)value + range.getMaximum() - (long)current + 1L - range.getMinimum());
    }

    private <T extends Temporal> T tryPrevious(T date, int value, int current) {
        if (current > value) {
            return this.field.add(date, value - current);
        }
        ValueRange range = this.field.range(date);
        return this.field.add(date, -((long)current - range.getMinimum() + 1L));
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueField that = (ValueField)o;
        return Objects.equals((Object)this.field, (Object)that.field) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.field, this.value});
    }
}

