/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.filters;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.intelie.pipes.Help;
import net.intelie.pipes.PropertyVisitor;
import net.intelie.pipes.Scope;
import net.intelie.pipes.filters.Filter;
import net.intelie.pipes.util.Iterables;

@Help(omit=true)
public class OrFilter
implements Filter {
    private static final long serialVersionUID = 1L;
    private final List<Filter> filters;

    public OrFilter(Filter ... filters) {
        this(Arrays.asList(filters));
    }

    public OrFilter(List<Filter> filters) {
        this.filters = filters;
    }

    public static boolean isNone(Filter filter) {
        return filter instanceof OrFilter && ((OrFilter)filter).isEmpty();
    }

    public String toString() {
        if (this.isEmpty()) {
            return "-*:*";
        }
        return "(" + Iterables.join(" || ", this.filters) + ")";
    }

    public boolean isEmpty() {
        return this.filters.size() == 0;
    }

    public List<Filter> filters() {
        return this.filters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrFilter that = (OrFilter)o;
        return Objects.equals(this.filters, that.filters);
    }

    public int hashCode() {
        return Objects.hash(this.filters);
    }

    @Override
    public PropertyVisitor visit(Scope scope, PropertyVisitor visitor) {
        for (Filter filter : this.filters) {
            filter.visit(scope, visitor);
        }
        return visitor;
    }
}

