/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.generated;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.ast.SourceLocation;
import net.intelie.pipes.generated.ParseException;
import net.intelie.pipes.generated.Token;

public class ParseExceptionMessage {
    public static String make(String message, Token currentToken, int[][] expectedTokenSequences, String[] tokenImage) {
        if (currentToken == null || expectedTokenSequences == null || tokenImage == null) {
            return message;
        }
        try {
            return "Unexpected " + ParseExceptionMessage.makeFound(tokenImage, expectedTokenSequences, currentToken.next) + ". " + ParseExceptionMessage.makeExpectedStr(tokenImage, expectedTokenSequences);
        }
        catch (Throwable e) {
            return message;
        }
    }

    private static String makeExpectedStr(String[] tokenImage, int[][] expectedTokenSequences) {
        Set<String> expected = ParseExceptionMessage.makeExpectedSet(tokenImage, expectedTokenSequences);
        ArrayList<String> expectedList = new ArrayList<String>(expected);
        String expectedStr = expectedList.size() > 1 ? "Was expecting one of: " : "Was expecting: ";
        for (int i = 0; i < Math.min(expectedList.size(), 3); ++i) {
            if (i > 0) {
                expectedStr = expectedStr + ", ";
            }
            expectedStr = expectedStr + (String)expectedList.get(i);
        }
        expectedStr = expectedList.size() > 3 ? expectedStr + "... (" + (expectedList.size() - 3) + " more)" : expectedStr + ".";
        return expectedStr;
    }

    private static String makeFound(String[] tokenImage, int[][] expectedTokenSequences, Token foundToken) {
        int maxSize = ParseExceptionMessage.findMaxSize(expectedTokenSequences);
        String found = "";
        for (int i = 0; i < maxSize; ++i) {
            if (i != 0) {
                found = found + " ";
            }
            if (foundToken.kind == 0) {
                found = found + tokenImage[0];
                break;
            }
            found = found + "\"" + foundToken.image + "\"";
            foundToken = foundToken.next;
        }
        return found;
    }

    private static Set<String> makeExpectedSet(String[] tokenImage, int[][] expectedTokenSequences) {
        LinkedHashSet<String> expected = new LinkedHashSet<String>();
        for (int[] sequence : expectedTokenSequences) {
            String s = "";
            for (int j = 0; j < sequence.length; ++j) {
                if (j > 0) {
                    s = s + " ";
                }
                s = s + tokenImage[sequence[j]];
            }
            expected.add(s);
        }
        return expected;
    }

    private static int findMaxSize(int[][] expectedTokenSequences) {
        int maxSize = 0;
        for (int[] sequence : expectedTokenSequences) {
            if (maxSize >= sequence.length) continue;
            maxSize = sequence.length;
        }
        return maxSize;
    }

    public static PipeException handle(Throwable e, SourceLocation location) {
        if (e instanceof ParseException && ((ParseException)e).currentToken != null) {
            return new PipeException(new SourceLocation(((ParseException)e).currentToken.next.beginLine, ((ParseException)e).currentToken.next.beginColumn), PipeException.Level.SYNTACTIC, ParseExceptionMessage.make(e.getMessage(), ((ParseException)e).currentToken, ((ParseException)e).expectedTokenSequences, ((ParseException)e).tokenImage));
        }
        return PipeException.handle(e).maybeAddSource(location);
    }
}

