/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.time;

import java.time.ZoneId;
import java.util.Objects;
import net.intelie.pipes.time.CompositeSpan;
import net.intelie.pipes.time.Period;
import net.intelie.pipes.time.PeriodSpan;
import net.intelie.pipes.time.PeriodUnit;
import net.intelie.pipes.time.SimplePeriod;
import net.intelie.pipes.time.TimeSpan;
import net.intelie.pipes.time.TimeSpanBase;
import net.intelie.pipes.util.Preconditions;

public class BeforeSpan
extends TimeSpanBase {
    private static final long serialVersionUID = 1L;
    private final TimeSpan span;
    private final Period periods;

    public BeforeSpan(TimeSpan span) {
        this(span, null);
    }

    public BeforeSpan(TimeSpan span, Period periods) {
        super((periods != null ? periods + " " : "") + "before $1", span = BeforeSpan.checkSpan(span));
        this.periods = periods;
        this.span = span;
    }

    @Override
    public BeforeSpan forceZone(ZoneId zone) {
        return new BeforeSpan(BeforeSpan.forceZone(this.span, zone), BeforeSpan.forceZone(this.periods, zone));
    }

    private static TimeSpan checkSpan(TimeSpan span) {
        Preconditions.checkNotNull(span, "span");
        return span instanceof CompositeSpan ? ((CompositeSpan)span).startSpan() : span;
    }

    public static BeforeSpan yesterday(ZoneId zone) {
        return BeforeSpan.previous(new SimplePeriod(1, PeriodUnit.DAY, zone));
    }

    public static BeforeSpan previous(SimplePeriod period) {
        return new BeforeSpan(new PeriodSpan(period.unitary()), period);
    }

    @Override
    public long start(long reference) {
        reference = this.span.start(reference);
        if (this.periods != null) {
            reference = this.periods.sub(reference);
        }
        return reference;
    }

    @Override
    public long end(long reference) {
        return this.span.start(reference);
    }

    @Override
    public boolean isFixed() {
        return this.span.isFixed();
    }

    @Override
    public boolean isPoint() {
        return this.periods == null;
    }

    @Override
    public boolean includesPresent() {
        return this.span.isPoint() && this.span.includesPresent();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BeforeSpan)) {
            return false;
        }
        BeforeSpan that = (BeforeSpan)o;
        return Objects.equals(this.span, that.span) && Objects.equals(this.periods, that.periods);
    }

    public int hashCode() {
        return Objects.hash(this.span, this.periods);
    }
}

