/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.time;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import net.intelie.pipes.time.PeriodBase;

public class CalendarPeriodBase
implements PeriodBase {
    private static final long serialVersionUID = 1L;
    private final int amount;
    private final ChronoField field;
    private final ZoneId zone;

    public CalendarPeriodBase(int amount, ChronoField field, ZoneId zone) {
        this.amount = amount;
        this.field = field;
        this.zone = zone;
    }

    @Override
    public long add(long timestamp) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestamp), this.zone).plus(this.amount, this.field.getBaseUnit()).toInstant().toEpochMilli();
    }

    @Override
    public long sub(long timestamp) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestamp), this.zone).minus(this.amount, this.field.getBaseUnit()).toInstant().toEpochMilli();
    }

    @Override
    public long floor(long timestamp) {
        ZonedDateTime date = ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestamp), this.zone);
        ZonedDateTime roundedFloor = this.truncate(date);
        return roundedFloor.minus((date.get(this.field) - 1) % this.amount, this.field.getBaseUnit()).toInstant().toEpochMilli();
    }

    private ZonedDateTime truncate(ZonedDateTime date) {
        if (this.field == ChronoField.YEAR) {
            return date.with(TemporalAdjusters.firstDayOfYear()).truncatedTo(ChronoUnit.DAYS);
        }
        if (this.field == ChronoField.MONTH_OF_YEAR) {
            return date.with(TemporalAdjusters.firstDayOfMonth()).truncatedTo(ChronoUnit.DAYS);
        }
        if (this.field == ChronoField.ALIGNED_WEEK_OF_YEAR) {
            return date.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY)).truncatedTo(ChronoUnit.DAYS);
        }
        return date.truncatedTo(this.field.getBaseUnit());
    }

    @Override
    public long estimateMillis() {
        return this.field.getBaseUnit().getDuration().toMillis() * (long)this.amount;
    }
}

