/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.time;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Locale;
import java.util.Objects;
import net.intelie.pipes.time.PeriodBase;
import net.intelie.pipes.time.PeriodUnit;
import net.intelie.pipes.time.TimeSpan;
import net.intelie.pipes.time.TimeSpanBase;
import net.intelie.pipes.util.DSTHelper;

public class DateSpan
extends TimeSpanBase {
    private static final long serialVersionUID = 1L;
    private final long start;
    private final long end;
    private final int year;
    private final int month;
    private final int day;
    private final int hour;
    private final int minute;
    private final int second;
    private final PeriodUnit span;

    public DateSpan(int year, int month, int day, int hour, int minute, int second, PeriodUnit span, ZoneId zone) {
        super(DateSpan.pad(year, 4) + (PeriodUnit.MONTH.compareTo(span) >= 0 ? "-" + DateSpan.pad(month, 2) : "") + (PeriodUnit.DAY.compareTo(span) >= 0 ? "-" + DateSpan.pad(day, 2) : "") + (PeriodUnit.HOUR.compareTo(span) >= 0 ? " " + DateSpan.pad(hour, 2) : "") + (PeriodUnit.MINUTE.compareTo(span) >= 0 ? ":" + DateSpan.pad(minute, 2) : "") + (PeriodUnit.SECOND.compareTo(span) >= 0 ? ":" + DateSpan.pad(second, 2) : ""), new TimeSpan[0]);
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.span = span;
        PeriodBase adder = span.create(1, zone);
        LocalDateTime local = LocalDateTime.of(year, month, day, hour, minute, second);
        local = DSTHelper.nextValid(local, zone);
        this.start = adder.floor(ZonedDateTime.of(local, zone).toInstant().toEpochMilli());
        this.end = adder.add(this.start);
    }

    @Override
    public DateSpan forceZone(ZoneId zone) {
        return new DateSpan(this.year, this.month, this.day, this.hour, this.minute, this.second, this.span, zone);
    }

    private static String pad(int v, int length) {
        return String.format((Locale)null, "%0" + length + "d", v);
    }

    @Override
    public long start(long reference) {
        return this.start;
    }

    @Override
    public long end(long reference) {
        return this.end;
    }

    @Override
    public boolean isFixed() {
        return true;
    }

    @Override
    public boolean isPoint() {
        return false;
    }

    @Override
    public boolean includesPresent() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DateSpan)) {
            return false;
        }
        DateSpan that = (DateSpan)o;
        return Objects.equals(this.start, that.start) && Objects.equals(this.end, that.end);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }
}

