/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.time;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import net.intelie.pipes.time.Clock;
import net.intelie.pipes.time.ClockScheduler;
import net.intelie.pipes.time.DefaultSchedulerContext;
import net.intelie.pipes.time.SchedulerContext;
import net.intelie.pipes.time.SystemClock;

public class DefaultScheduler
implements ClockScheduler {
    private final ScheduledExecutorService executor;
    private final Clock clock;

    public DefaultScheduler() {
        this(Executors.newSingleThreadScheduledExecutor());
    }

    public DefaultScheduler(ScheduledExecutorService executor) {
        this(executor, new SystemClock());
    }

    public DefaultScheduler(ScheduledExecutorService executor, Clock clock) {
        this.executor = executor;
        this.clock = clock;
    }

    @Override
    public SchedulerContext newContext() {
        return new DefaultSchedulerContext(this.executor, this.clock);
    }

    public SchedulerContext newContext(long offset) {
        return new DefaultSchedulerContext(this.executor, this.clock, offset);
    }

    @Override
    public long now() {
        return this.clock.now();
    }
}

