/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.time;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Locale;
import java.util.Objects;
import net.intelie.pipes.time.PeriodUnit;
import net.intelie.pipes.time.SimplePeriod;
import net.intelie.pipes.time.TimeSpan;
import net.intelie.pipes.time.TimeSpanBase;
import net.intelie.pipes.util.DSTHelper;

public class HourSpan
extends TimeSpanBase {
    private static final long serialVersionUID = 1L;
    private final int hour;
    private final int minute;
    private final int second;
    private final ZoneId zone;
    private final SimplePeriod unit;

    public HourSpan(int hour, int minute, int second, PeriodUnit span, ZoneId zone) {
        super(HourSpan.pad(hour, 2) + (PeriodUnit.MINUTE.compareTo(span) < 0 ? "h" : "") + (PeriodUnit.MINUTE.compareTo(span) >= 0 ? ":" + HourSpan.pad(minute, 2) : "") + (PeriodUnit.SECOND.compareTo(span) >= 0 ? ":" + HourSpan.pad(second, 2) : ""), new TimeSpan[0]);
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.zone = zone;
        this.unit = new SimplePeriod(1, span, zone);
    }

    @Override
    public HourSpan forceZone(ZoneId zone) {
        return new HourSpan(this.hour, this.minute, this.second, this.unit.unit(), zone);
    }

    private static String pad(int v, int length) {
        return String.format((Locale)null, "%0" + length + "d", v);
    }

    @Override
    public long start(long reference) {
        LocalDateTime local = ZonedDateTime.ofInstant(Instant.ofEpochMilli(reference), this.zone).toLocalDateTime().withHour(this.hour).withMinute(this.minute).withSecond(this.second).withNano(0);
        local = DSTHelper.nextValid(local, this.zone);
        return ZonedDateTime.of(local, this.zone).toInstant().toEpochMilli();
    }

    @Override
    public long end(long reference) {
        return this.unit.add(this.start(reference));
    }

    @Override
    public boolean isFixed() {
        return false;
    }

    @Override
    public boolean isPoint() {
        return false;
    }

    @Override
    public boolean includesPresent() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HourSpan)) {
            return false;
        }
        HourSpan that = (HourSpan)o;
        return Objects.equals(this.hour, that.hour) && Objects.equals(this.minute, that.minute) && Objects.equals(this.second, that.second) && Objects.equals(this.unit, that.unit) && Objects.equals(this.zone, that.zone);
    }

    public int hashCode() {
        return Objects.hash(this.hour, this.minute, this.second, this.unit, this.zone);
    }
}

