/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.time;

import java.time.ZoneId;
import java.util.Objects;
import net.intelie.pipes.time.Period;
import net.intelie.pipes.time.PeriodSpan;
import net.intelie.pipes.time.PeriodUnit;
import net.intelie.pipes.time.SimplePeriod;
import net.intelie.pipes.time.TimeSpan;
import net.intelie.pipes.time.TimeSpanBase;
import net.intelie.pipes.util.Preconditions;

public class InsideSpan
extends TimeSpanBase {
    private static final long serialVersionUID = 1L;
    private final int ordinal;
    private final Period period;
    private final TimeSpan span;
    private final Period cache;
    private final Period cache2;

    public InsideSpan(int ordinal, Period period, TimeSpan span) {
        super(InsideSpan.reprOrdinal(ordinal) + " " + Preconditions.checkNotNull(period, "period").toString(false) + " of $1", Preconditions.checkNotNull(span, "span"));
        this.ordinal = ordinal;
        this.period = period;
        this.span = span;
        this.cache = ordinal > 1 ? period.multiply(ordinal - 1) : null;
        this.cache2 = period.multiply(ordinal);
    }

    @Override
    public InsideSpan forceZone(ZoneId zone) {
        return new InsideSpan(this.ordinal, InsideSpan.forceZone(this.period, zone), InsideSpan.forceZone(this.span, zone));
    }

    private static String reprOrdinal(int ordinal) {
        Preconditions.checkArgument(ordinal > 0, "ordinal must be > 0: %d", ordinal);
        return ordinal != 1 ? InsideSpan.th(ordinal) : "first";
    }

    public static InsideSpan monthOfYear(int ordinal, ZoneId tz) {
        return new InsideSpan(ordinal, new SimplePeriod(1, PeriodUnit.MONTH, tz), (TimeSpan)new PeriodSpan(new SimplePeriod(1, PeriodUnit.YEAR, tz)));
    }

    public static InsideSpan dayOfWeek(int ordinal, ZoneId tz) {
        return InsideSpan.dayOfSpan(ordinal, tz, new PeriodSpan(new SimplePeriod(1, PeriodUnit.WEEK, tz)));
    }

    public static InsideSpan dayOfSpan(int ordinal, ZoneId tz, TimeSpan span) {
        return new InsideSpan(ordinal, new SimplePeriod(1, PeriodUnit.DAY, tz), span);
    }

    @Override
    public long start(long reference) {
        reference = this.span.start(reference);
        if (this.cache != null) {
            reference = this.cache.add(reference);
        }
        return reference;
    }

    @Override
    public long end(long reference) {
        reference = this.span.start(reference);
        reference = this.cache2.add(reference);
        return reference;
    }

    @Override
    public boolean isFixed() {
        return this.span.isFixed();
    }

    @Override
    public boolean isPoint() {
        return false;
    }

    @Override
    public boolean includesPresent() {
        return this.span.includesPresent() && this.span.isPoint();
    }

    private static String th(int n) {
        int mod10 = n % 10;
        int mod100 = n % 100;
        if (mod10 == 1 && mod100 != 11) {
            return n + "st";
        }
        if (mod10 == 2 && mod100 != 12) {
            return n + "nd";
        }
        if (mod10 == 3 && mod100 != 13) {
            return n + "rd";
        }
        return n + "th";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InsideSpan)) {
            return false;
        }
        InsideSpan that = (InsideSpan)o;
        return Objects.equals(this.span, that.span) && Objects.equals(this.ordinal, that.ordinal) && Objects.equals(this.period, that.period);
    }

    public int hashCode() {
        return Objects.hash(this.span, this.ordinal, this.period);
    }
}

