/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.time;

import java.time.ZoneId;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.intelie.pipes.time.TimeSpan;
import net.intelie.pipes.time.TimeSpanBase;
import net.intelie.pipes.util.Iterables;
import net.intelie.pipes.util.Preconditions;

public class IntersectionSpan
extends TimeSpanBase {
    private static final long serialVersionUID = 1L;
    private final List<TimeSpan> spans;

    public IntersectionSpan(List<TimeSpan> spans) {
        super(IntersectionSpan.makeRepr(spans), spans.toArray(new TimeSpan[0]));
        Preconditions.checkArgument(spans.size() > 0, "Must have at least one span.");
        this.spans = spans;
    }

    private static String makeRepr(List<TimeSpan> spans) {
        return "intersection of " + Iterables.joinWithLast(", ", " and ", IntStream.rangeClosed(1, spans.size()).mapToObj(x -> "$" + x).collect(Collectors.toList()));
    }

    @Override
    public IntersectionSpan forceZone(ZoneId zone) {
        return new IntersectionSpan(this.spans.stream().map(x -> x.forceZone(zone)).collect(Collectors.toList()));
    }

    public List<TimeSpan> spans() {
        return Collections.unmodifiableList(this.spans);
    }

    @Override
    public long start(long reference) {
        return this.spans.stream().mapToLong(x -> x.start(reference)).max().orElse(reference);
    }

    @Override
    public long end(long reference) {
        return this.spans.stream().mapToLong(x -> x.end(reference)).min().orElse(reference);
    }

    @Override
    public boolean isFixed() {
        return this.spans.stream().allMatch(TimeSpan::isFixed);
    }

    @Override
    public boolean isPoint() {
        return this.spans.stream().anyMatch(TimeSpan::isPoint);
    }

    @Override
    public boolean includesPresent() {
        return this.spans.stream().allMatch(TimeSpan::includesPresent);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntersectionSpan)) {
            return false;
        }
        IntersectionSpan that = (IntersectionSpan)o;
        return Objects.equals(this.spans, that.spans);
    }

    public int hashCode() {
        return Objects.hash(this.spans);
    }
}

