/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.time;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.intelie.pipes.time.Period;
import net.intelie.pipes.time.PeriodIterator;
import net.intelie.pipes.time.SchedulerContext;
import net.intelie.pipes.time.Task;
import net.intelie.pipes.time.TaskAction;
import net.intelie.pipes.time.TaskHandle;
import net.intelie.pipes.time.TaskRunner;

public class ManualSchedulerContext
implements SchedulerContext {
    public static final TaskRunner.Default DEFAULT_RUNNER = new TaskRunner.Default();
    private final PriorityQueue<DefaultTaskHandle> queue = new PriorityQueue();
    private List<DefaultTaskHandle> buffer = new ArrayList<DefaultTaskHandle>();
    private final TaskRunner runner;
    private volatile long events;
    private volatile long startTime;
    private long now;
    private int currentIndex;
    private volatile long nextTimestamp = 0L;

    public ManualSchedulerContext() {
        this(null);
    }

    public ManualSchedulerContext(TaskRunner runner) {
        this.runner = runner != null ? runner : DEFAULT_RUNNER;
        this.startTime = -1L;
    }

    @Override
    public synchronized DefaultTaskHandle schedule(Period period, Task runnable) {
        return this.scheduleAt(period, runnable, this.now);
    }

    public synchronized DefaultTaskHandle scheduleAt(Period period, Task runnable, long timestamp) {
        DefaultTaskHandle handle = new DefaultTaskHandle(this.currentIndex++, this.events, period, runnable);
        if (!this.started()) {
            this.buffer.add(handle);
        } else {
            handle.start(timestamp);
            this.queueAdd(handle);
        }
        return handle;
    }

    private void queueAdd(DefaultTaskHandle handle) {
        this.queue.add(handle);
        this.nextTimestamp = this.queue.peek().nextTimestamp();
    }

    public synchronized long notifyEvent() {
        return ++this.events;
    }

    @Override
    public long now() {
        return this.now;
    }

    @Override
    public boolean started() {
        return this.startTime >= 0L;
    }

    @Override
    public long startTime() {
        return this.startTime;
    }

    @Override
    public synchronized long nextTaskTimestamp() {
        DefaultTaskHandle top = this.peekActive();
        if (top != null) {
            return top.nextTimestamp();
        }
        return Long.MAX_VALUE;
    }

    private DefaultTaskHandle peekActive() {
        assert (Thread.holdsLock(this));
        while (!this.queue.isEmpty() && !this.queue.peek().active()) {
            this.queue.poll();
        }
        return this.queue.peek();
    }

    @Override
    public synchronized void start() {
        if (!this.started()) {
            this.startTime = this.now();
            for (DefaultTaskHandle handle : this.buffer) {
                handle.start(this.startTime);
                this.queueAdd(handle);
            }
            this.buffer = null;
        }
    }

    public void start(long timestamp) {
        if (!this.started()) {
            this.advanceTo(timestamp);
            this.start();
        }
    }

    public void advanceTo(long timestamp) {
        if (timestamp < this.nextTimestamp) {
            this.updateNow(timestamp);
            return;
        }
        this.internalFlush(timestamp, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalFlush(long timestamp, boolean last) {
        while (true) {
            long run;
            ArrayList<TaskAction> actions;
            ManualSchedulerContext manualSchedulerContext = this;
            synchronized (manualSchedulerContext) {
                DefaultTaskHandle handle;
                if (last && this.buffer != null) {
                    this.buffer.clear();
                }
                if ((handle = this.peekActive()) == null || !last && handle.nextTimestamp() > timestamp) {
                    break;
                }
                actions = new ArrayList<TaskAction>();
                run = handle.window.end();
                while (handle != null && handle.window.end() == run) {
                    DefaultTaskHandle task = this.queue.poll();
                    if (!last || task.lastEvent != this.events) {
                        actions.add(new TaskAction(task.window.begin(), task.window.end(), task.runnable));
                        task.lastEvent = this.events;
                    }
                    task.window.moveNext();
                    if (!last) {
                        this.queueAdd(task);
                    }
                    handle = this.peekActive();
                }
                this.now = run;
            }
            assert (!Thread.holdsLock(this));
            if (actions.isEmpty()) continue;
            try {
                this.runner.onTasks(run, actions);
            }
            catch (Throwable e) {
                Logger.getLogger(ManualSchedulerContext.class.getName()).log(Level.WARNING, "Uncaught exception", e);
            }
        }
        this.updateNow(timestamp);
    }

    private synchronized void updateNow(long timestamp) {
        this.now = Math.max(this.now, timestamp);
    }

    public synchronized Set<Period> periods() {
        LinkedHashSet<Period> periods = new LinkedHashSet<Period>();
        for (DefaultTaskHandle handle : this.queue) {
            periods.add(handle.period);
        }
        if (this.buffer != null) {
            for (DefaultTaskHandle handle : this.buffer) {
                periods.add(handle.period);
            }
        }
        return periods;
    }

    @Override
    public synchronized void cancelAll() {
        if (this.buffer != null) {
            this.buffer.clear();
        }
        this.queue.clear();
    }

    public void flushAndCancelAll() {
        this.internalFlush(0L, true);
    }

    public static class DefaultTaskHandle
    implements TaskHandle,
    Comparable<DefaultTaskHandle> {
        private final int index;
        private final Period period;
        private Task runnable;
        private volatile boolean active = true;
        private PeriodIterator window;
        private volatile long lastEvent;

        public DefaultTaskHandle(int index, long lastEvent, Period period, Task runnable) {
            this.index = index;
            this.period = period;
            this.runnable = runnable;
            this.lastEvent = lastEvent;
        }

        @Override
        public void cancel() {
            this.active = false;
            this.runnable = null;
        }

        @Override
        public int compareTo(DefaultTaskHandle that) {
            if (this.nextTimestamp() != that.nextTimestamp()) {
                return Long.compare(this.nextTimestamp(), that.nextTimestamp());
            }
            return Integer.compare(this.index, that.index);
        }

        @Override
        public long nextTimestamp() {
            return this.window.end();
        }

        public boolean active() {
            return this.active;
        }

        public void start(long time) {
            this.window = new PeriodIterator(time, true, this.period);
        }
    }
}

