/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.time;

import java.time.ZoneId;
import java.util.Objects;
import net.intelie.pipes.time.Period;
import net.intelie.pipes.time.PeriodUnit;
import net.intelie.pipes.time.SimplePeriod;
import net.intelie.pipes.time.TimeSpan;
import net.intelie.pipes.time.TimeSpanBase;
import net.intelie.pipes.util.Preconditions;

public class PeriodSpan
extends TimeSpanBase {
    private static final long serialVersionUID = 1L;
    private final Period period;
    private final TimeSpan span;

    public PeriodSpan(Period period) {
        this(period, null);
    }

    public PeriodSpan(Period period, TimeSpan span) {
        super(span == null ? "current " + period.toString(false) : "the " + period.toString(false) + " of $1", span);
        Preconditions.checkArgument(period.supportsFloor(), "Period '%s' doesn't support alignment");
        this.period = period;
        this.span = span;
    }

    @Override
    public PeriodSpan forceZone(ZoneId zone) {
        return new PeriodSpan(PeriodSpan.forceZone(this.period, zone), PeriodSpan.forceZone(this.span, zone));
    }

    public static PeriodSpan today(ZoneId zone) {
        return new PeriodSpan(new SimplePeriod(1, PeriodUnit.DAY, zone));
    }

    public Period period() {
        return this.period;
    }

    public TimeSpan span() {
        return this.span;
    }

    @Override
    public long start(long reference) {
        if (this.span != null) {
            reference = this.span.start(reference);
        }
        return this.period.floor(reference);
    }

    @Override
    public long end(long reference) {
        reference = this.start(reference);
        return this.period.floor(this.period.add(reference));
    }

    @Override
    public boolean isFixed() {
        return this.span != null && this.span.isFixed();
    }

    @Override
    public boolean isPoint() {
        return false;
    }

    @Override
    public boolean includesPresent() {
        return this.span == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PeriodSpan)) {
            return false;
        }
        PeriodSpan that = (PeriodSpan)o;
        return Objects.equals(this.period, that.period) && Objects.equals(this.span, that.span);
    }

    public int hashCode() {
        return Objects.hash(this.period, this.span);
    }
}

