/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.time;

import java.time.ZoneId;
import java.util.Objects;
import net.intelie.pipes.time.TimeSpan;
import net.intelie.pipes.time.TimeSpanBase;
import net.intelie.pipes.util.Preconditions;

public class ShiftToSpan
extends TimeSpanBase {
    private static final long serialVersionUID = 1L;
    private final TimeSpan refSpan;
    private final TimeSpan span;

    public ShiftToSpan(TimeSpan span, TimeSpan refSpan) {
        super("$1 shifted to $2", Preconditions.checkNotNull(span, "span"), Preconditions.checkNotNull(refSpan, "refSpan"));
        this.refSpan = refSpan;
        this.span = span;
    }

    @Override
    public ShiftToSpan forceZone(ZoneId zone) {
        return new ShiftToSpan(ShiftToSpan.forceZone(this.span, zone), ShiftToSpan.forceZone(this.refSpan, zone));
    }

    @Override
    public long start(long reference) {
        reference = this.refSpan.start(reference);
        return this.span.start(reference);
    }

    @Override
    public long end(long reference) {
        reference = this.refSpan.start(reference);
        return this.span.end(reference);
    }

    @Override
    public boolean isFixed() {
        return this.span.isFixed() || this.refSpan.isFixed();
    }

    @Override
    public boolean isPoint() {
        return this.span.isPoint();
    }

    @Override
    public boolean includesPresent() {
        return this.span.includesPresent() && this.refSpan.includesPresent();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShiftToSpan)) {
            return false;
        }
        ShiftToSpan that = (ShiftToSpan)o;
        return Objects.equals(this.refSpan, that.refSpan) && Objects.equals(this.span, that.span);
    }

    public int hashCode() {
        return Objects.hash(this.refSpan, this.span);
    }
}

