/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.time;

import java.io.ObjectStreamException;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.intelie.pipes.time.Period;
import net.intelie.pipes.time.PeriodBase;
import net.intelie.pipes.time.PeriodUnit;
import net.intelie.pipes.util.Preconditions;

public class SimplePeriod
implements Period {
    private static final long serialVersionUID = 1L;
    private final int amount;
    private final PeriodUnit unit;
    private final ZoneId zone;
    private final transient PeriodBase adder;

    public SimplePeriod(int amount, String unit) {
        this(amount, PeriodUnit.fromName(unit));
    }

    public SimplePeriod(int amount, String unit, ZoneId zone) {
        this(amount, PeriodUnit.fromName(unit), zone);
    }

    public SimplePeriod(int amount, PeriodUnit unit) {
        this(amount, unit, null);
    }

    public SimplePeriod(int amount, PeriodUnit unit, ZoneId zone) {
        Preconditions.checkArgument(amount > 0, "Period can not have non-positive amount: %s", amount);
        if (zone == null) {
            zone = ZoneId.systemDefault();
        }
        this.zone = zone;
        this.unit = unit;
        this.amount = amount;
        this.adder = unit.create(amount, zone);
    }

    @Override
    public SimplePeriod forceZone(ZoneId zone) {
        return new SimplePeriod(this.amount, this.unit, zone);
    }

    private Object readResolve() throws ObjectStreamException {
        return new SimplePeriod(this.amount, this.unit, this.zone);
    }

    @Override
    public Map<String, Object> simple() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("amount", Double.valueOf(this.amount));
        map.put("unit", this.unit.name());
        map.put("zone", this.zone.getId());
        return map;
    }

    public int amount() {
        return this.amount;
    }

    public PeriodUnit unit() {
        return this.unit;
    }

    public ZoneId zone() {
        return this.zone;
    }

    @Override
    public SimplePeriod multiply(int amount) {
        return new SimplePeriod(this.amount * amount, this.unit, this.zone);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimplePeriod)) {
            return false;
        }
        SimplePeriod that = (SimplePeriod)o;
        return Objects.equals(this.amount, that.amount) && Objects.equals(this.unit, that.unit) && Objects.equals(this.zone, that.zone);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.unit, this.zone);
    }

    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeOne) {
        return this.unit.toString(this.amount, includeOne);
    }

    @Override
    public long add(long timestamp) {
        return this.adder.add(timestamp);
    }

    @Override
    public long sub(long timestamp) {
        return this.adder.sub(timestamp);
    }

    @Override
    public long floor(long timestamp) {
        return this.adder.floor(timestamp);
    }

    @Override
    public boolean supportsFloor() {
        return true;
    }

    @Override
    public long estimateMillis() {
        return this.adder.estimateMillis();
    }

    public SimplePeriod unitary() {
        return new SimplePeriod(1, this.unit, this.zone);
    }
}

