/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.time;

import java.time.ZoneId;
import java.util.Objects;
import net.intelie.pipes.time.TimeSpan;
import net.intelie.pipes.time.TimeSpanBase;

public class TimestampSpan
extends TimeSpanBase {
    private static final long serialVersionUID = 1L;
    private final long timestamp;

    public TimestampSpan(long timestamp) {
        super("timestamp " + timestamp, new TimeSpan[0]);
        this.timestamp = timestamp;
    }

    @Override
    public TimestampSpan forceZone(ZoneId zone) {
        return new TimestampSpan(this.timestamp);
    }

    @Override
    public long start(long reference) {
        return this.timestamp;
    }

    @Override
    public long end(long reference) {
        return this.timestamp;
    }

    @Override
    public boolean isFixed() {
        return true;
    }

    @Override
    public boolean isPoint() {
        return true;
    }

    @Override
    public boolean includesPresent() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TimestampSpan)) {
            return false;
        }
        TimestampSpan that = (TimestampSpan)o;
        return Objects.equals(this.timestamp, that.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp);
    }
}

