/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.time;

import java.time.ZoneId;
import java.util.Objects;
import net.intelie.pipes.time.TimeSpan;
import net.intelie.pipes.time.TimeSpanBase;
import net.intelie.pipes.util.Preconditions;

public class WindowOfSpan
extends TimeSpanBase {
    private static final long serialVersionUID = 1L;
    private final TimeSpan span;
    private final Object cacheLock = new Object[0];
    private long cacheArg = -1L;
    private long cacheRes;

    public WindowOfSpan(TimeSpan span) {
        super("window of $1", Preconditions.checkNotNull(span, "span"));
        this.span = span;
    }

    @Override
    public WindowOfSpan forceZone(ZoneId zone) {
        return new WindowOfSpan(this.span.forceZone(zone));
    }

    @Override
    public long start(long reference) {
        return this.span.start(this.findReference(reference));
    }

    @Override
    public long end(long reference) {
        return this.span.end(this.findReference(reference));
    }

    @Override
    public boolean isFixed() {
        return this.span.isFixed();
    }

    @Override
    public boolean isPoint() {
        return this.span.isPoint();
    }

    @Override
    public boolean includesPresent() {
        return !this.span.isFixed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long findReference(long timestamp) {
        long dist;
        Object object = this.cacheLock;
        synchronized (object) {
            if (this.cacheArg == timestamp) {
                return this.cacheRes;
            }
        }
        long max = (Long.MAX_VALUE - timestamp) / 2L;
        for (dist = 3600000L; dist < max && (this.span.end(timestamp + dist) < timestamp || this.span.end(timestamp - dist) >= timestamp); dist *= 2L) {
        }
        long first = timestamp - dist;
        long count = dist * 2L;
        while (count > 0L) {
            long it = first;
            long step = count / 2L;
            if (this.span.end(it += step) < timestamp) {
                first = ++it;
                count -= step + 1L;
                continue;
            }
            count = step;
        }
        Object object2 = this.cacheLock;
        synchronized (object2) {
            this.cacheArg = timestamp;
            this.cacheRes = first;
        }
        return first;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WindowOfSpan that = (WindowOfSpan)o;
        return Objects.equals(this.span, that.span);
    }

    public int hashCode() {
        return Objects.hash(this.span);
    }
}

