/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.types;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.intelie.pipes.types.Output;
import net.intelie.pipes.types.OutputType;

public class BatchOutput
implements Output {
    private static final long serialVersionUID = 1L;
    private final int amount;

    public BatchOutput(int amount) {
        if (amount <= 0) {
            throw new IllegalArgumentException("Batch amount can not have non-positive amount: " + amount);
        }
        this.amount = amount;
    }

    @Override
    public Map<String, Object> simple() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "batch");
        map.put("amount", this.amount);
        return map;
    }

    @Override
    public OutputType type() {
        return OutputType.ITEM;
    }

    public int amount() {
        return this.amount;
    }

    public String toString() {
        return "every " + this.amount + (this.amount == 1 ? " batch" : " batches");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BatchOutput)) {
            return false;
        }
        BatchOutput that = (BatchOutput)o;
        return Objects.equals(this.amount, that.amount);
    }

    public int hashCode() {
        return Objects.hash(this.amount);
    }
}

