/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.types;

import java.util.Collections;
import java.util.List;
import net.intelie.pipes.types.BinaryIterator;
import net.intelie.pipes.types.Type;

public final class BooleanType
extends Type<Boolean> {
    private static final long serialVersionUID = 1L;

    public BooleanType() {
        super(Boolean.class, "boolean");
    }

    @Override
    public final Boolean cast(Object value) {
        if (value == null) {
            return null;
        }
        return !("".equals(value) || Boolean.FALSE.equals(value) || "false".equalsIgnoreCase(String.valueOf(value)) || value instanceof Number && ((Number)value).longValue() == 0L || value instanceof Enum && ((Enum)value).ordinal() == 0);
    }

    @Override
    public List<Type> typeChain() {
        return Collections.singletonList(Type.COMPARABLE);
    }

    @Override
    public BinaryIterator newIterator() {
        return new BooleanIterator();
    }

    private static class BooleanIterator
    implements BinaryIterator {
        private int b;
        private int i;

        private BooleanIterator() {
        }

        @Override
        public boolean reset(Object value) {
            this.b = Boolean.TRUE.equals(Type.BOOLEAN.cast(value)) ? 65535 : 0;
            this.i = -1;
            return true;
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean isLast() {
            return this.i + 1 >= 1;
        }

        @Override
        public boolean moveNext() {
            return ++this.i < 1;
        }

        @Override
        public int current() {
            return this.b;
        }
    }
}

