/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.types;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterator;
import java.util.stream.Stream;
import net.intelie.pipes.types.FieldInfo;
import net.intelie.pipes.util.Iterables;

public class ClauseInfo
implements Iterable<FieldInfo>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<FieldInfo> fields = new ArrayList<FieldInfo>();

    public ClauseInfo(FieldInfo ... fields) {
        this(Arrays.asList(fields));
    }

    public ClauseInfo(Iterable<FieldInfo> fields) {
        for (FieldInfo field : fields) {
            this.fields.add(field);
        }
    }

    @Override
    public Iterator<FieldInfo> iterator() {
        return this.fields.iterator();
    }

    @Override
    public Spliterator<FieldInfo> spliterator() {
        return this.fields.spliterator();
    }

    public Stream<FieldInfo> stream() {
        return this.fields.stream();
    }

    public int size() {
        return this.fields.size();
    }

    public List<Map<String, Object>> simple() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (FieldInfo field : this.fields) {
            list.add(field.simple());
        }
        return list;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClauseInfo)) {
            return false;
        }
        ClauseInfo that = (ClauseInfo)o;
        return Objects.equals(this.fields, that.fields);
    }

    public int hashCode() {
        return Objects.hash(this.fields);
    }

    public String toString() {
        return Iterables.join(", ", this.fields);
    }
}

