/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.types;

import java.util.Objects;
import java.util.stream.Collectors;
import net.intelie.pipes.PipeException;
import net.intelie.pipes.types.MapType;
import net.intelie.pipes.types.MapTypeResolver;
import net.intelie.pipes.types.ResolverState;
import net.intelie.pipes.types.RowFields;
import net.intelie.pipes.types.RowType;
import net.intelie.pipes.types.RowTypeResolver;
import net.intelie.pipes.types.SeqType;
import net.intelie.pipes.types.SeqTypeResolver;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.types.TypeResolver;

public class DirectTypeResolver
implements TypeResolver {
    private static final long serialVersionUID = 1L;
    private final Type type;

    private DirectTypeResolver(Type type) {
        this.type = type;
    }

    public static TypeResolver create(Type type) {
        if (type instanceof RowType) {
            RowFields fields = ((RowType)type).fields();
            if (fields == null) {
                return new RowTypeResolver(null);
            }
            return new RowTypeResolver(new RowTypeResolver.FieldList(fields.timestamp().stream().map(x -> new RowTypeResolver.Field(x.name(), DirectTypeResolver.create(x.type()))).collect(Collectors.toList()), fields.group().stream().map(x -> new RowTypeResolver.Field(x.name(), DirectTypeResolver.create(x.type()))).collect(Collectors.toList()), fields.select().stream().map(x -> new RowTypeResolver.Field(x.name(), DirectTypeResolver.create(x.type()))).collect(Collectors.toList())));
        }
        if (type instanceof MapType) {
            return new MapTypeResolver(DirectTypeResolver.create(((MapType)type).keyType()), DirectTypeResolver.create(((MapType)type).valueType()));
        }
        if (type instanceof SeqType) {
            return new SeqTypeResolver(DirectTypeResolver.create(((SeqType)type).type()));
        }
        return new DirectTypeResolver(type);
    }

    @Override
    public Type resolve(ResolverState state) {
        return this.type;
    }

    @Override
    public void update(Type found, ResolverState state) throws PipeException {
        if (!found.isAssignableTo(this.type)) {
            throw new PipeException("Expected type: %s. Found: %s.", this.type, found);
        }
    }

    public Type type() {
        return this.type;
    }

    @Override
    public TypeResolver removeWildcards(ResolverState state) {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirectTypeResolver that = (DirectTypeResolver)o;
        return Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.type);
    }

    public String toString() {
        return this.type.displayName();
    }
}

