/*
 * Decompiled with CFR 0.152.
 */
package net.intelie.pipes.types;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.intelie.pipes.types.Type;
import net.intelie.pipes.util.Escapes;

public class FieldInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Type type;

    public FieldInfo(String name, Type type) {
        this.name = name;
        this.type = type;
    }

    public String name() {
        return this.name;
    }

    public Type type() {
        return this.type;
    }

    public Map<String, Object> simple() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", this.name);
        map.put("type", this.type.displayName());
        return map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FieldInfo)) {
            return false;
        }
        FieldInfo that = (FieldInfo)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type);
    }

    public String toString() {
        return this.type + " " + Escapes.formatIdentifier(this.name);
    }
}

